package io.vertx.mutiny.ext.web.handler;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.ext.web.handler.LoggerFormat;
import java.util.function.Function;

/**
 * A handler which logs request information to the Vert.x logger.
 * You should mount this handler before any handler that could fail the routing context
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.LoggerHandler original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.handler.LoggerHandler.class)
public class LoggerHandler implements io.vertx.mutiny.ext.web.handler.PlatformHandler, io.vertx.core.Handler<io.vertx.mutiny.ext.web.RoutingContext>, java.util.function.Consumer<io.vertx.mutiny.ext.web.RoutingContext> {

  public static final io.smallrye.mutiny.vertx.TypeArg<LoggerHandler> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new LoggerHandler((io.vertx.ext.web.handler.LoggerHandler) obj),
    LoggerHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.LoggerHandler delegate;
  
  public LoggerHandler(io.vertx.ext.web.handler.LoggerHandler delegate) {
    this.delegate = delegate;
  }

  public LoggerHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.LoggerHandler)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  LoggerHandler() {
    this.delegate = null;
  }

  public io.vertx.ext.web.handler.LoggerHandler getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    LoggerHandler that = (LoggerHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public void handle(io.vertx.mutiny.ext.web.RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

  /**
   * @return the handler
   */
  public static io.vertx.mutiny.ext.web.handler.LoggerHandler create() { 
    io.vertx.mutiny.ext.web.handler.LoggerHandler ret = io.vertx.mutiny.ext.web.handler.LoggerHandler.newInstance((io.vertx.ext.web.handler.LoggerHandler)io.vertx.ext.web.handler.LoggerHandler.create());
    return ret;
  }

  /**
   * @param format the format
   * @return the handler
   */
  public static io.vertx.mutiny.ext.web.handler.LoggerHandler create(io.vertx.ext.web.handler.LoggerFormat format) { 
    io.vertx.mutiny.ext.web.handler.LoggerHandler ret = io.vertx.mutiny.ext.web.handler.LoggerHandler.newInstance((io.vertx.ext.web.handler.LoggerHandler)io.vertx.ext.web.handler.LoggerHandler.create(format));
    return ret;
  }

  /**
   * @param immediate true if logging should occur as soon as request arrives
   * @param format the format
   * @return the handler
   */
  public static io.vertx.mutiny.ext.web.handler.LoggerHandler create(boolean immediate, io.vertx.ext.web.handler.LoggerFormat format) { 
    io.vertx.mutiny.ext.web.handler.LoggerHandler ret = io.vertx.mutiny.ext.web.handler.LoggerHandler.newInstance((io.vertx.ext.web.handler.LoggerHandler)io.vertx.ext.web.handler.LoggerHandler.create(immediate, format));
    return ret;
  }

  /**
   * @param formatter the formatting function
   * @return the formatted log string
   * @deprecated Superseded by {@link #customFormatter(LoggerFormatter)}   */
  @Deprecated
  @Fluent
  public io.vertx.mutiny.ext.web.handler.LoggerHandler customFormatter(Function<io.vertx.mutiny.core.http.HttpServerRequest, String> formatter) { 
    delegate.customFormatter(new java.util.function.Function<io.vertx.core.http.HttpServerRequest,java.lang.String>() {
      public String apply(io.vertx.core.http.HttpServerRequest arg) {
        String ret = formatter.apply(io.vertx.mutiny.core.http.HttpServerRequest.newInstance((io.vertx.core.http.HttpServerRequest)arg));
        return ret;
      }
    });
    return this;
  }

  /**
   * @param formatter the formatter
   * @return the formatted log string
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.LoggerHandler customFormatter(io.vertx.mutiny.ext.web.handler.LoggerFormatter formatter) { 
    delegate.customFormatter(formatter.getDelegate());
    return this;
  }

  public static final LoggerFormat DEFAULT_FORMAT = io.vertx.ext.web.handler.LoggerHandler.DEFAULT_FORMAT;
  public void accept(io.vertx.mutiny.ext.web.RoutingContext item) {
    handle(item);
  }
  public static  LoggerHandler newInstance(io.vertx.ext.web.handler.LoggerHandler arg) {
    return arg != null ? new LoggerHandler(arg) : null;
  }

}
