package io.vertx.mutiny.ext.web.handler;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;

/**
 * An auth handler that provides HTTP Basic Authentication support.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.BasicAuthHandler original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.handler.BasicAuthHandler.class)
public class BasicAuthHandler implements io.vertx.mutiny.ext.web.handler.AuthenticationHandler, io.vertx.core.Handler<io.vertx.mutiny.ext.web.RoutingContext>, java.util.function.Consumer<io.vertx.mutiny.ext.web.RoutingContext> {

  public static final io.smallrye.mutiny.vertx.TypeArg<BasicAuthHandler> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new BasicAuthHandler((io.vertx.ext.web.handler.BasicAuthHandler) obj),
    BasicAuthHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.BasicAuthHandler delegate;
  
  public BasicAuthHandler(io.vertx.ext.web.handler.BasicAuthHandler delegate) {
    this.delegate = delegate;
  }

  public BasicAuthHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.BasicAuthHandler)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  BasicAuthHandler() {
    this.delegate = null;
  }

  public io.vertx.ext.web.handler.BasicAuthHandler getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BasicAuthHandler that = (BasicAuthHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public void handle(io.vertx.mutiny.ext.web.RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

  /**
   * @param authProvider the auth provider to use
   * @return the auth handler
   */
  public static io.vertx.mutiny.ext.web.handler.BasicAuthHandler create(io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider authProvider) { 
    io.vertx.mutiny.ext.web.handler.BasicAuthHandler ret = io.vertx.mutiny.ext.web.handler.BasicAuthHandler.newInstance((io.vertx.ext.web.handler.BasicAuthHandler)io.vertx.ext.web.handler.BasicAuthHandler.create(authProvider.getDelegate()));
    return ret;
  }

  /**
   * @param authProvider the auth service to use
   * @param realm the realm to use
   * @return the auth handler
   */
  public static io.vertx.mutiny.ext.web.handler.BasicAuthHandler create(io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider authProvider, String realm) { 
    io.vertx.mutiny.ext.web.handler.BasicAuthHandler ret = io.vertx.mutiny.ext.web.handler.BasicAuthHandler.newInstance((io.vertx.ext.web.handler.BasicAuthHandler)io.vertx.ext.web.handler.BasicAuthHandler.create(authProvider.getDelegate(), realm));
    return ret;
  }

  /**
   * The default realm to use
   */
  public static final String DEFAULT_REALM = io.vertx.ext.web.handler.BasicAuthHandler.DEFAULT_REALM;
  public void accept(io.vertx.mutiny.ext.web.RoutingContext item) {
    handle(item);
  }
  public static  BasicAuthHandler newInstance(io.vertx.ext.web.handler.BasicAuthHandler arg) {
    return arg != null ? new BasicAuthHandler(arg) : null;
  }

}
