package io.vertx.mutiny.ext.web.handler;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;

/**
 * An auth handler that provides One Time Password (Multi-Factor) Authentication support.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.OtpAuthHandler original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.handler.OtpAuthHandler.class)
public class OtpAuthHandler implements io.vertx.mutiny.ext.web.handler.AuthenticationHandler, io.vertx.core.Handler<io.vertx.mutiny.ext.web.RoutingContext>, java.util.function.Consumer<io.vertx.mutiny.ext.web.RoutingContext> {

  public static final io.smallrye.mutiny.vertx.TypeArg<OtpAuthHandler> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new OtpAuthHandler((io.vertx.ext.web.handler.OtpAuthHandler) obj),
    OtpAuthHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.OtpAuthHandler delegate;
  
  public OtpAuthHandler(io.vertx.ext.web.handler.OtpAuthHandler delegate) {
    this.delegate = delegate;
  }

  public OtpAuthHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.OtpAuthHandler)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  OtpAuthHandler() {
    this.delegate = null;
  }

  public io.vertx.ext.web.handler.OtpAuthHandler getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OtpAuthHandler that = (OtpAuthHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public void handle(io.vertx.mutiny.ext.web.RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

  /**
   * @param totpAuth the time based OTP provider.
   * @return new instance of the handler.
   */
  public static io.vertx.mutiny.ext.web.handler.OtpAuthHandler create(io.vertx.mutiny.ext.auth.otp.totp.TotpAuth totpAuth) { 
    io.vertx.mutiny.ext.web.handler.OtpAuthHandler ret = io.vertx.mutiny.ext.web.handler.OtpAuthHandler.newInstance((io.vertx.ext.web.handler.OtpAuthHandler)io.vertx.ext.web.handler.OtpAuthHandler.create(totpAuth.getDelegate()));
    return ret;
  }

  /**
   * @param hotpAuth the hash based OTP provider.
   * @return new instance of the handler.
   */
  public static io.vertx.mutiny.ext.web.handler.OtpAuthHandler create(io.vertx.mutiny.ext.auth.otp.hotp.HotpAuth hotpAuth) { 
    io.vertx.mutiny.ext.web.handler.OtpAuthHandler ret = io.vertx.mutiny.ext.web.handler.OtpAuthHandler.newInstance((io.vertx.ext.web.handler.OtpAuthHandler)io.vertx.ext.web.handler.OtpAuthHandler.create(hotpAuth.getDelegate()));
    return ret;
  }

  /**
   * @param url the location where users are to be asked for the OTP code.
   * @return fluent self.
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.OtpAuthHandler verifyUrl(String url) { 
    delegate.verifyUrl(url);
    return this;
  }

  /**
   * @param route the location where users are to register new authenticator devices/apps.
   * @return fluent self.
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.OtpAuthHandler setupRegisterCallback(io.vertx.mutiny.ext.web.Route route) { 
    delegate.setupRegisterCallback(route.getDelegate());
    return this;
  }

  /**
   * @param route the location where users are to submit challenge responses from authenticator devices/apps.
   * @return fluent self.
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.OtpAuthHandler setupCallback(io.vertx.mutiny.ext.web.Route route) { 
    delegate.setupCallback(route.getDelegate());
    return this;
  }

  /**
   * @param issuer a <code>String</code> for example <code>Vert.x OTP</code>
   * @return fluent self.
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.OtpAuthHandler issuer(String issuer) { 
    delegate.issuer(issuer);
    return this;
  }

  /**
   * @param label a <code>String</code> for example <code>Vert.x OTP</code>
   * @return fluent self.
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.OtpAuthHandler label(String label) { 
    delegate.label(label);
    return this;
  }

  public void accept(io.vertx.mutiny.ext.web.RoutingContext item) {
    handle(item);
  }
  public static  OtpAuthHandler newInstance(io.vertx.ext.web.handler.OtpAuthHandler arg) {
    return arg != null ? new OtpAuthHandler(arg) : null;
  }

}
