/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.ext.web.handler;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Handler;
import io.vertx.core.http.CookieSameSite;
import io.vertx.ext.web.sstore.SessionStore;
import io.vertx.mutiny.ext.auth.AuthProvider;
import io.vertx.mutiny.ext.auth.User;
import io.vertx.mutiny.ext.web.RoutingContext;
import io.vertx.mutiny.ext.web.Session;
import java.util.function.Consumer;

@MutinyGen(value=io.vertx.ext.web.handler.SessionHandler.class)
public class SessionHandler
implements Handler<RoutingContext>,
Consumer<RoutingContext> {
    public static final TypeArg<SessionHandler> __TYPE_ARG = new TypeArg(obj -> new SessionHandler((io.vertx.ext.web.handler.SessionHandler)obj), SessionHandler::getDelegate);
    private final io.vertx.ext.web.handler.SessionHandler delegate;
    public static final String DEFAULT_SESSION_COOKIE_NAME = "vertx-web.session";
    public static final String DEFAULT_SESSION_COOKIE_PATH = "/";
    public static final long DEFAULT_SESSION_TIMEOUT = 1800000L;
    public static final boolean DEFAULT_NAG_HTTPS = true;
    public static final boolean DEFAULT_COOKIE_HTTP_ONLY_FLAG = false;
    public static final boolean DEFAULT_COOKIE_SECURE_FLAG = false;
    public static final int DEFAULT_SESSIONID_MIN_LENGTH = 16;
    public static final boolean DEFAULT_LAZY_SESSION = false;

    public SessionHandler(io.vertx.ext.web.handler.SessionHandler delegate) {
        this.delegate = delegate;
    }

    public SessionHandler(Object delegate) {
        this.delegate = (io.vertx.ext.web.handler.SessionHandler)delegate;
    }

    SessionHandler() {
        this.delegate = null;
    }

    public io.vertx.ext.web.handler.SessionHandler getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionHandler that = (SessionHandler)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public void handle(RoutingContext arg0) {
        this.delegate.handle((Object)arg0.getDelegate());
    }

    public static SessionHandler create(io.vertx.mutiny.ext.web.sstore.SessionStore sessionStore) {
        SessionHandler ret = SessionHandler.newInstance(io.vertx.ext.web.handler.SessionHandler.create((SessionStore)sessionStore.getDelegate()));
        return ret;
    }

    @Fluent
    public SessionHandler setSessionTimeout(long timeout) {
        this.delegate.setSessionTimeout(timeout);
        return this;
    }

    @Fluent
    public SessionHandler setNagHttps(boolean nag) {
        this.delegate.setNagHttps(nag);
        return this;
    }

    @Fluent
    public SessionHandler setCookieSecureFlag(boolean secure) {
        this.delegate.setCookieSecureFlag(secure);
        return this;
    }

    @Fluent
    public SessionHandler setCookieHttpOnlyFlag(boolean httpOnly) {
        this.delegate.setCookieHttpOnlyFlag(httpOnly);
        return this;
    }

    @Fluent
    public SessionHandler setSessionCookieName(String sessionCookieName) {
        this.delegate.setSessionCookieName(sessionCookieName);
        return this;
    }

    @Fluent
    public SessionHandler setSessionCookiePath(String sessionCookiePath) {
        this.delegate.setSessionCookiePath(sessionCookiePath);
        return this;
    }

    @Fluent
    public SessionHandler setMinLength(int minLength) {
        this.delegate.setMinLength(minLength);
        return this;
    }

    @Fluent
    public SessionHandler setCookieSameSite(CookieSameSite policy) {
        this.delegate.setCookieSameSite(policy);
        return this;
    }

    @Fluent
    public SessionHandler setLazySession(boolean lazySession) {
        this.delegate.setLazySession(lazySession);
        return this;
    }

    @Fluent
    public SessionHandler setCookieMaxAge(long cookieMaxAge) {
        this.delegate.setCookieMaxAge(cookieMaxAge);
        return this;
    }

    @Deprecated
    @Fluent
    public SessionHandler setAuthProvider(AuthProvider authProvider) {
        this.delegate.setAuthProvider(authProvider.getDelegate());
        return this;
    }

    public Uni<Void> flush(RoutingContext ctx) {
        return AsyncResultUni.toUni(handler -> this.delegate.flush(ctx.getDelegate(), handler));
    }

    public Void flushAndAwait(RoutingContext ctx) {
        return (Void)this.flush(ctx).await().indefinitely();
    }

    @Fluent
    public SessionHandler flushAndForget(RoutingContext ctx) {
        this.flush(ctx).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public Uni<Void> flush(RoutingContext ctx, boolean ignoreStatus) {
        return AsyncResultUni.toUni(handler -> this.delegate.flush(ctx.getDelegate(), ignoreStatus, handler));
    }

    public Void flushAndAwait(RoutingContext ctx, boolean ignoreStatus) {
        return (Void)this.flush(ctx, ignoreStatus).await().indefinitely();
    }

    @Fluent
    public SessionHandler flushAndForget(RoutingContext ctx, boolean ignoreStatus) {
        this.flush(ctx, ignoreStatus).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Fluent
    public SessionHandler setCookieless(boolean cookieless) {
        this.delegate.setCookieless(cookieless);
        return this;
    }

    public Session newSession(RoutingContext context) {
        Session ret = Session.newInstance(this.delegate.newSession(context.getDelegate()));
        return ret;
    }

    public Uni<Void> setUser(RoutingContext context, User user) {
        return AsyncResultUni.toUni(handler -> this.delegate.setUser(context.getDelegate(), user.getDelegate(), handler));
    }

    public Void setUserAndAwait(RoutingContext context, User user) {
        return (Void)this.setUser(context, user).await().indefinitely();
    }

    @Fluent
    public SessionHandler setUserAndForget(RoutingContext context, User user) {
        this.setUser(context, user).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Override
    public void accept(RoutingContext item) {
        this.handle(item);
    }

    public static SessionHandler newInstance(io.vertx.ext.web.handler.SessionHandler arg) {
        return arg != null ? new SessionHandler(arg) : null;
    }
}

