package io.vertx.mutiny.ext.web.handler;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;

/**
 * An auth handler that provides FIDO2 WebAuthN Relay Party support.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.WebAuthnHandler original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.handler.WebAuthnHandler.class)
public class WebAuthnHandler implements io.vertx.mutiny.ext.web.handler.AuthenticationHandler, io.vertx.core.Handler<io.vertx.mutiny.ext.web.RoutingContext>, java.util.function.Consumer<io.vertx.mutiny.ext.web.RoutingContext> {

  public static final io.smallrye.mutiny.vertx.TypeArg<WebAuthnHandler> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new WebAuthnHandler((io.vertx.ext.web.handler.WebAuthnHandler) obj),
    WebAuthnHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.WebAuthnHandler delegate;
  
  public WebAuthnHandler(io.vertx.ext.web.handler.WebAuthnHandler delegate) {
    this.delegate = delegate;
  }

  public WebAuthnHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.WebAuthnHandler)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  WebAuthnHandler() {
    this.delegate = null;
  }

  public io.vertx.ext.web.handler.WebAuthnHandler getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    WebAuthnHandler that = (WebAuthnHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public void handle(io.vertx.mutiny.ext.web.RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

  /**
   * @param webAuthn 
   * @return the auth handler
   */
  public static io.vertx.mutiny.ext.web.handler.WebAuthnHandler create(io.vertx.mutiny.ext.auth.webauthn.WebAuthn webAuthn) { 
    io.vertx.mutiny.ext.web.handler.WebAuthnHandler ret = io.vertx.mutiny.ext.web.handler.WebAuthnHandler.newInstance((io.vertx.ext.web.handler.WebAuthnHandler)io.vertx.ext.web.handler.WebAuthnHandler.create(webAuthn.getDelegate()));
    return ret;
  }

  /**
   * @param route the route where credential get options are generated.
   * @return fluent self.
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.WebAuthnHandler setupCredentialsCreateCallback(io.vertx.mutiny.ext.web.Route route) { 
    delegate.setupCredentialsCreateCallback(route.getDelegate());
    return this;
  }

  /**
   * @param route the route where credential get options are generated.
   * @return fluent self.
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.WebAuthnHandler setupCredentialsGetCallback(io.vertx.mutiny.ext.web.Route route) { 
    delegate.setupCredentialsGetCallback(route.getDelegate());
    return this;
  }

  /**
   * @param route the route where assertions and attestations are verified.
   * @return fluent self.
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.WebAuthnHandler setupCallback(io.vertx.mutiny.ext.web.Route route) { 
    delegate.setupCallback(route.getDelegate());
    return this;
  }

  /**
   * @param origin - an HTTP Origin
   * @return fluent self
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.WebAuthnHandler setOrigin(String origin) { 
    delegate.setOrigin(origin);
    return this;
  }

  public void accept(io.vertx.mutiny.ext.web.RoutingContext item) {
    handle(item);
  }
  public static  WebAuthnHandler newInstance(io.vertx.ext.web.handler.WebAuthnHandler arg) {
    return arg != null ? new WebAuthnHandler(arg) : null;
  }

}
