package io.vertx.mutiny.ext.web.handler;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.function.Function;
import io.vertx.core.Future;

/**
 * A user customizable authentication handler.
 * <p>
 * An auth handler allows your application to provide authentication support. The handler is not fully functional
 * without a authentication function. This function takes the  as input and returns a .
 *
 * The future should return a non <code>null</code> user object. In the {@link io.vertx.mutiny.ext.web.handler.SimpleAuthenticationHandler#authenticate} you have full control
 * on the request, so all operations like redirect, next, fail are allowed. There are some rules that need to be followed
 * in order to allow this handler to properly interop with {@link io.vertx.mutiny.ext.web.handler.ChainAuthHandler}.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.SimpleAuthenticationHandler original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.handler.SimpleAuthenticationHandler.class)
public class SimpleAuthenticationHandler implements io.vertx.mutiny.ext.web.handler.AuthenticationHandler, io.vertx.core.Handler<io.vertx.mutiny.ext.web.RoutingContext>, java.util.function.Consumer<io.vertx.mutiny.ext.web.RoutingContext> {

  public static final io.smallrye.mutiny.vertx.TypeArg<SimpleAuthenticationHandler> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new SimpleAuthenticationHandler((io.vertx.ext.web.handler.SimpleAuthenticationHandler) obj),
    SimpleAuthenticationHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.SimpleAuthenticationHandler delegate;
  
  public SimpleAuthenticationHandler(io.vertx.ext.web.handler.SimpleAuthenticationHandler delegate) {
    this.delegate = delegate;
  }

  public SimpleAuthenticationHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.SimpleAuthenticationHandler)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  SimpleAuthenticationHandler() {
    this.delegate = null;
  }

  public io.vertx.ext.web.handler.SimpleAuthenticationHandler getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SimpleAuthenticationHandler that = (SimpleAuthenticationHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public void handle(io.vertx.mutiny.ext.web.RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

  /**
   * @return a new instance.
   */
  public static io.vertx.mutiny.ext.web.handler.SimpleAuthenticationHandler create() { 
    io.vertx.mutiny.ext.web.handler.SimpleAuthenticationHandler ret = io.vertx.mutiny.ext.web.handler.SimpleAuthenticationHandler.newInstance((io.vertx.ext.web.handler.SimpleAuthenticationHandler)io.vertx.ext.web.handler.SimpleAuthenticationHandler.create());
    return ret;
  }

  /**
   * @param authenticationFunction the authentication function.
   * @return self
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.SimpleAuthenticationHandler authenticate(Function<io.vertx.mutiny.ext.web.RoutingContext, io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.auth.User>> authenticationFunction) { 
    delegate.authenticate(new java.util.function.Function<io.vertx.ext.web.RoutingContext,io.vertx.core.Future<io.vertx.ext.auth.User>>() {
      public io.vertx.core.Future<io.vertx.ext.auth.User> apply(io.vertx.ext.web.RoutingContext arg) {
            return io.smallrye.mutiny.vertx.UniHelper.toFuture(
                 authenticationFunction.apply(io.vertx.mutiny.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)arg)).map(x -> x.getDelegate())
            );
         }
     });
    return this;
  }

  public void accept(io.vertx.mutiny.ext.web.RoutingContext item) {
    handle(item);
  }
  public static  SimpleAuthenticationHandler newInstance(io.vertx.ext.web.handler.SimpleAuthenticationHandler arg) {
    return arg != null ? new SimpleAuthenticationHandler(arg) : null;
  }

}
