/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.ext.stomp;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Handler;
import io.vertx.ext.stomp.Frame;
import io.vertx.mutiny.core.buffer.Buffer;
import java.util.Map;
import java.util.function.Consumer;

@MutinyGen(value=io.vertx.ext.stomp.StompClientConnection.class)
public class StompClientConnection {
    public static final TypeArg<StompClientConnection> __TYPE_ARG = new TypeArg(obj -> new StompClientConnection((io.vertx.ext.stomp.StompClientConnection)obj), StompClientConnection::getDelegate);
    private final io.vertx.ext.stomp.StompClientConnection delegate;

    public StompClientConnection(io.vertx.ext.stomp.StompClientConnection delegate) {
        this.delegate = delegate;
    }

    public StompClientConnection(Object delegate) {
        this.delegate = (io.vertx.ext.stomp.StompClientConnection)delegate;
    }

    StompClientConnection() {
        this.delegate = null;
    }

    public io.vertx.ext.stomp.StompClientConnection getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StompClientConnection that = (StompClientConnection)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String session() {
        String ret = this.delegate.session();
        return ret;
    }

    public String version() {
        String ret = this.delegate.version();
        return ret;
    }

    public void close() {
        this.delegate.close();
    }

    public String server() {
        String ret = this.delegate.server();
        return ret;
    }

    @CheckReturnValue
    public Uni<Frame> send(Map<String, String> headers, Buffer body) {
        return AsyncResultUni.toUni(receiptHandler -> this.delegate.send(headers, body.getDelegate(), receiptHandler));
    }

    public Frame sendAndAwait(Map<String, String> headers, Buffer body) {
        return (Frame)this.send(headers, body).await().indefinitely();
    }

    @Fluent
    public StompClientConnection sendAndForget(Map<String, String> headers, Buffer body) {
        this.send(headers, body).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Frame> send(String destination, Buffer body) {
        return AsyncResultUni.toUni(receiptHandler -> this.delegate.send(destination, body.getDelegate(), receiptHandler));
    }

    public Frame sendAndAwait(String destination, Buffer body) {
        return (Frame)this.send(destination, body).await().indefinitely();
    }

    @Fluent
    public StompClientConnection sendAndForget(String destination, Buffer body) {
        this.send(destination, body).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Frame> send(Frame frame) {
        return AsyncResultUni.toUni(receiptHandler -> this.delegate.send(frame, receiptHandler));
    }

    public Frame sendAndAwait(Frame frame) {
        return (Frame)this.send(frame).await().indefinitely();
    }

    @Fluent
    public StompClientConnection sendAndForget(Frame frame) {
        this.send(frame).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Frame> send(String destination, Map<String, String> headers, Buffer body) {
        return AsyncResultUni.toUni(receiptHandler -> this.delegate.send(destination, headers, body.getDelegate(), receiptHandler));
    }

    public Frame sendAndAwait(String destination, Map<String, String> headers, Buffer body) {
        return (Frame)this.send(destination, headers, body).await().indefinitely();
    }

    @Fluent
    public StompClientConnection sendAndForget(String destination, Map<String, String> headers, Buffer body) {
        this.send(destination, headers, body).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<String> subscribe(String destination, Consumer<Frame> handler) {
        return AsyncResultUni.toUni(receiptHandler -> this.delegate.subscribe(destination, handler::accept, receiptHandler));
    }

    public String subscribeAndAwait(String destination, Consumer<Frame> handler) {
        return (String)this.subscribe(destination, handler).await().indefinitely();
    }

    @Fluent
    public StompClientConnection subscribeAndForget(String destination, Consumer<Frame> handler) {
        this.subscribe(destination, handler).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<String> subscribe(String destination, Map<String, String> headers, Consumer<Frame> handler) {
        return AsyncResultUni.toUni(receiptHandler -> this.delegate.subscribe(destination, headers, handler::accept, receiptHandler));
    }

    public String subscribeAndAwait(String destination, Map<String, String> headers, Consumer<Frame> handler) {
        return (String)this.subscribe(destination, headers, handler).await().indefinitely();
    }

    @Fluent
    public StompClientConnection subscribeAndForget(String destination, Map<String, String> headers, Consumer<Frame> handler) {
        this.subscribe(destination, headers, handler).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Frame> unsubscribe(String destination) {
        return AsyncResultUni.toUni(receiptHandler -> this.delegate.unsubscribe(destination, receiptHandler));
    }

    public Frame unsubscribeAndAwait(String destination) {
        return (Frame)this.unsubscribe(destination).await().indefinitely();
    }

    @Fluent
    public StompClientConnection unsubscribeAndForget(String destination) {
        this.unsubscribe(destination).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Frame> unsubscribe(String destination, Map<String, String> headers) {
        return AsyncResultUni.toUni(receiptHandler -> this.delegate.unsubscribe(destination, headers, receiptHandler));
    }

    public Frame unsubscribeAndAwait(String destination, Map<String, String> headers) {
        return (Frame)this.unsubscribe(destination, headers).await().indefinitely();
    }

    @Fluent
    public StompClientConnection unsubscribeAndForget(String destination, Map<String, String> headers) {
        this.unsubscribe(destination, headers).subscribe().with(UniHelper.NOOP);
        return this;
    }

    private StompClientConnection __errorHandler(Handler<Frame> handler) {
        StompClientConnection ret = StompClientConnection.newInstance(this.delegate.errorHandler(handler));
        return ret;
    }

    public StompClientConnection errorHandler(Consumer<Frame> handler) {
        return this.__errorHandler(handler != null ? handler::accept : null);
    }

    @Fluent
    private StompClientConnection __closeHandler(final Handler<StompClientConnection> handler) {
        this.delegate.closeHandler((Handler)new Handler<io.vertx.ext.stomp.StompClientConnection>(){

            public void handle(io.vertx.ext.stomp.StompClientConnection event) {
                handler.handle((Object)StompClientConnection.newInstance(event));
            }
        });
        return this;
    }

    public StompClientConnection closeHandler(Consumer<StompClientConnection> handler) {
        return this.__closeHandler(handler != null ? handler::accept : null);
    }

    @Fluent
    private StompClientConnection __connectionDroppedHandler(final Handler<StompClientConnection> handler) {
        this.delegate.connectionDroppedHandler((Handler)new Handler<io.vertx.ext.stomp.StompClientConnection>(){

            public void handle(io.vertx.ext.stomp.StompClientConnection event) {
                handler.handle((Object)StompClientConnection.newInstance(event));
            }
        });
        return this;
    }

    public StompClientConnection connectionDroppedHandler(Consumer<StompClientConnection> handler) {
        return this.__connectionDroppedHandler(handler != null ? handler::accept : null);
    }

    @Fluent
    private StompClientConnection __pingHandler(final Handler<StompClientConnection> handler) {
        this.delegate.pingHandler((Handler)new Handler<io.vertx.ext.stomp.StompClientConnection>(){

            public void handle(io.vertx.ext.stomp.StompClientConnection event) {
                handler.handle((Object)StompClientConnection.newInstance(event));
            }
        });
        return this;
    }

    public StompClientConnection pingHandler(Consumer<StompClientConnection> handler) {
        return this.__pingHandler(handler != null ? handler::accept : null);
    }

    @CheckReturnValue
    public Uni<Frame> beginTX(String id) {
        return AsyncResultUni.toUni(receiptHandler -> this.delegate.beginTX(id, receiptHandler));
    }

    public Frame beginTXAndAwait(String id) {
        return (Frame)this.beginTX(id).await().indefinitely();
    }

    @Fluent
    public StompClientConnection beginTXAndForget(String id) {
        this.beginTX(id).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Frame> beginTX(String id, Map<String, String> headers) {
        return AsyncResultUni.toUni(receiptHandler -> this.delegate.beginTX(id, headers, receiptHandler));
    }

    public Frame beginTXAndAwait(String id, Map<String, String> headers) {
        return (Frame)this.beginTX(id, headers).await().indefinitely();
    }

    @Fluent
    public StompClientConnection beginTXAndForget(String id, Map<String, String> headers) {
        this.beginTX(id, headers).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Frame> commit(String id) {
        return AsyncResultUni.toUni(receiptHandler -> this.delegate.commit(id, receiptHandler));
    }

    public Frame commitAndAwait(String id) {
        return (Frame)this.commit(id).await().indefinitely();
    }

    @Fluent
    public StompClientConnection commitAndForget(String id) {
        this.commit(id).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Frame> commit(String id, Map<String, String> headers) {
        return AsyncResultUni.toUni(receiptHandler -> this.delegate.commit(id, headers, receiptHandler));
    }

    public Frame commitAndAwait(String id, Map<String, String> headers) {
        return (Frame)this.commit(id, headers).await().indefinitely();
    }

    @Fluent
    public StompClientConnection commitAndForget(String id, Map<String, String> headers) {
        this.commit(id, headers).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Frame> abort(String id) {
        return AsyncResultUni.toUni(receiptHandler -> this.delegate.abort(id, receiptHandler));
    }

    public Frame abortAndAwait(String id) {
        return (Frame)this.abort(id).await().indefinitely();
    }

    @Fluent
    public StompClientConnection abortAndForget(String id) {
        this.abort(id).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Frame> abort(String id, Map<String, String> headers) {
        return AsyncResultUni.toUni(receiptHandler -> this.delegate.abort(id, headers, receiptHandler));
    }

    public Frame abortAndAwait(String id, Map<String, String> headers) {
        return (Frame)this.abort(id, headers).await().indefinitely();
    }

    @Fluent
    public StompClientConnection abortAndForget(String id, Map<String, String> headers) {
        this.abort(id, headers).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Frame> disconnect() {
        return AsyncResultUni.toUni(receiptHandler -> this.delegate.disconnect(receiptHandler));
    }

    public Frame disconnectAndAwait() {
        return (Frame)this.disconnect().await().indefinitely();
    }

    @Fluent
    public StompClientConnection disconnectAndForget() {
        this.disconnect().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Frame> disconnect(Frame frame) {
        return AsyncResultUni.toUni(receiptHandler -> this.delegate.disconnect(frame, receiptHandler));
    }

    public Frame disconnectAndAwait(Frame frame) {
        return (Frame)this.disconnect(frame).await().indefinitely();
    }

    @Fluent
    public StompClientConnection disconnectAndForget(Frame frame) {
        this.disconnect(frame).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Frame> ack(String id) {
        return AsyncResultUni.toUni(receiptHandler -> this.delegate.ack(id, receiptHandler));
    }

    public Frame ackAndAwait(String id) {
        return (Frame)this.ack(id).await().indefinitely();
    }

    @Fluent
    public StompClientConnection ackAndForget(String id) {
        this.ack(id).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Frame> nack(String id) {
        return AsyncResultUni.toUni(receiptHandler -> this.delegate.nack(id, receiptHandler));
    }

    public Frame nackAndAwait(String id) {
        return (Frame)this.nack(id).await().indefinitely();
    }

    @Fluent
    public StompClientConnection nackAndForget(String id) {
        this.nack(id).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Frame> ack(String id, String txId) {
        return AsyncResultUni.toUni(receiptHandler -> this.delegate.ack(id, txId, receiptHandler));
    }

    public Frame ackAndAwait(String id, String txId) {
        return (Frame)this.ack(id, txId).await().indefinitely();
    }

    @Fluent
    public StompClientConnection ackAndForget(String id, String txId) {
        this.ack(id, txId).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Frame> nack(String id, String txId) {
        return AsyncResultUni.toUni(receiptHandler -> this.delegate.nack(id, txId, receiptHandler));
    }

    public Frame nackAndAwait(String id, String txId) {
        return (Frame)this.nack(id, txId).await().indefinitely();
    }

    @Fluent
    public StompClientConnection nackAndForget(String id, String txId) {
        this.nack(id, txId).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Fluent
    private StompClientConnection __receivedFrameHandler(Handler<Frame> handler) {
        this.delegate.receivedFrameHandler(handler);
        return this;
    }

    public StompClientConnection receivedFrameHandler(Consumer<Frame> handler) {
        return this.__receivedFrameHandler(handler != null ? handler::accept : null);
    }

    @Fluent
    private StompClientConnection __writingFrameHandler(Handler<Frame> handler) {
        this.delegate.writingFrameHandler(handler);
        return this;
    }

    public StompClientConnection writingFrameHandler(Consumer<Frame> handler) {
        return this.__writingFrameHandler(handler != null ? handler::accept : null);
    }

    @Fluent
    private StompClientConnection __exceptionHandler(Handler<Throwable> exceptionHandler) {
        this.delegate.exceptionHandler(exceptionHandler);
        return this;
    }

    public StompClientConnection exceptionHandler(Consumer<Throwable> exceptionHandler) {
        return this.__exceptionHandler(exceptionHandler != null ? exceptionHandler::accept : null);
    }

    public boolean isConnected() {
        boolean ret = this.delegate.isConnected();
        return ret;
    }

    public static StompClientConnection newInstance(io.vertx.ext.stomp.StompClientConnection arg) {
        return arg != null ? new StompClientConnection(arg) : null;
    }
}

