/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.sqlclient;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.mutiny.sqlclient.PreparedQuery;
import io.vertx.mutiny.sqlclient.Query;
import io.vertx.mutiny.sqlclient.Row;
import io.vertx.mutiny.sqlclient.RowSet;
import io.vertx.mutiny.sqlclient.SqlClient;
import io.vertx.mutiny.sqlclient.SqlConnection;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import java.util.function.Function;

@MutinyGen(value=io.vertx.sqlclient.Pool.class)
public class Pool
extends SqlClient {
    public static final TypeArg<Pool> __TYPE_ARG = new TypeArg(obj -> new Pool((io.vertx.sqlclient.Pool)obj), Pool::getDelegate);
    private final io.vertx.sqlclient.Pool delegate;
    static final TypeArg<RowSet<Row>> TYPE_ARG_0 = new TypeArg(o1 -> RowSet.newInstance((io.vertx.sqlclient.RowSet)o1, new TypeArg(o2 -> Row.newInstance((io.vertx.sqlclient.Row)o2), o2 -> o2.getDelegate())), o1 -> o1.getDelegate());
    static final TypeArg<RowSet<Row>> TYPE_ARG_1 = new TypeArg(o1 -> RowSet.newInstance((io.vertx.sqlclient.RowSet)o1, new TypeArg(o2 -> Row.newInstance((io.vertx.sqlclient.Row)o2), o2 -> o2.getDelegate())), o1 -> o1.getDelegate());

    public Pool(io.vertx.sqlclient.Pool delegate) {
        super((io.vertx.sqlclient.SqlClient)delegate);
        this.delegate = delegate;
    }

    public Pool(Object delegate) {
        super((io.vertx.sqlclient.SqlClient)((io.vertx.sqlclient.Pool)delegate));
        this.delegate = (io.vertx.sqlclient.Pool)delegate;
    }

    Pool() {
        super(null);
        this.delegate = null;
    }

    public io.vertx.sqlclient.Pool getDelegate() {
        return this.delegate;
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pool that = (Pool)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static Pool pool(SqlConnectOptions connectOptions) {
        Pool ret = Pool.newInstance(io.vertx.sqlclient.Pool.pool((SqlConnectOptions)connectOptions));
        return ret;
    }

    public static Pool pool(SqlConnectOptions connectOptions, PoolOptions poolOptions) {
        Pool ret = Pool.newInstance(io.vertx.sqlclient.Pool.pool((SqlConnectOptions)connectOptions, (PoolOptions)poolOptions));
        return ret;
    }

    public static Pool pool(io.vertx.mutiny.core.Vertx vertx, SqlConnectOptions connectOptions, PoolOptions poolOptions) {
        Pool ret = Pool.newInstance(io.vertx.sqlclient.Pool.pool((Vertx)vertx.getDelegate(), (SqlConnectOptions)connectOptions, (PoolOptions)poolOptions));
        return ret;
    }

    public Uni<SqlConnection> getConnection() {
        return AsyncResultUni.toUni(handler -> this.delegate.getConnection((Handler)new Handler<AsyncResult<io.vertx.sqlclient.SqlConnection>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.SqlConnection> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)SqlConnection.newInstance((io.vertx.sqlclient.SqlConnection)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public SqlConnection getConnectionAndAwait() {
        return (SqlConnection)this.getConnection().await().indefinitely();
    }

    public void getConnectionAndForget() {
        this.getConnection().subscribe().with(UniHelper.NOOP);
    }

    @Override
    public Query<RowSet<Row>> query(String sql) {
        Query<RowSet<Row>> ret = Query.newInstance(this.delegate.query(sql), TYPE_ARG_0);
        return ret;
    }

    @Override
    public PreparedQuery<RowSet<Row>> preparedQuery(String sql) {
        PreparedQuery<RowSet<Row>> ret = PreparedQuery.newInstance(this.delegate.preparedQuery(sql), TYPE_ARG_1);
        return ret;
    }

    public <T> Uni<T> withTransaction(final Function<SqlConnection, Uni<T>> function) {
        return AsyncResultUni.toUni(handler -> this.delegate.withTransaction(new Function<io.vertx.sqlclient.SqlConnection, Future<T>>(){

            @Override
            public Future<T> apply(io.vertx.sqlclient.SqlConnection arg) {
                return UniHelper.toFuture((Uni)((Uni)function.apply(SqlConnection.newInstance(arg))));
            }
        }, handler));
    }

    public <T> T withTransactionAndAwait(Function<SqlConnection, Uni<T>> function) {
        return (T)this.withTransaction(function).await().indefinitely();
    }

    public <T> void withTransactionAndForget(Function<SqlConnection, Uni<T>> function) {
        this.withTransaction(function).subscribe().with(UniHelper.NOOP);
    }

    public <T> Uni<T> withConnection(final Function<SqlConnection, Uni<T>> function) {
        return AsyncResultUni.toUni(handler -> this.delegate.withConnection(new Function<io.vertx.sqlclient.SqlConnection, Future<T>>(){

            @Override
            public Future<T> apply(io.vertx.sqlclient.SqlConnection arg) {
                return UniHelper.toFuture((Uni)((Uni)function.apply(SqlConnection.newInstance(arg))));
            }
        }, handler));
    }

    public <T> T withConnectionAndAwait(Function<SqlConnection, Uni<T>> function) {
        return (T)this.withConnection(function).await().indefinitely();
    }

    public <T> void withConnectionAndForget(Function<SqlConnection, Uni<T>> function) {
        this.withConnection(function).subscribe().with(UniHelper.NOOP);
    }

    @Override
    public Uni<Void> close() {
        return AsyncResultUni.toUni(handler -> this.delegate.close(handler));
    }

    @Override
    public Void closeAndAwait() {
        return (Void)this.close().await().indefinitely();
    }

    @Override
    public void closeAndForget() {
        this.close().subscribe().with(UniHelper.NOOP);
    }

    public static Pool newInstance(io.vertx.sqlclient.Pool arg) {
        return arg != null ? new Pool(arg) : null;
    }
}

