/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.sqlclient;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.sqlclient.Pool;
import io.vertx.mutiny.sqlclient.SqlClient;
import io.vertx.mutiny.sqlclient.SqlConnection;
import io.vertx.mutiny.sqlclient.Transaction;
import java.util.function.Function;
import org.reactivestreams.Publisher;

public class SqlClientHelper {
    public static <T> Multi<T> inTransactionMulti(Pool pool, Function<SqlClient, Multi<T>> sourceSupplier) {
        return SqlClientHelper.usingConnectionMulti(pool, conn -> {
            Transaction transaction = conn.begin();
            return Multi.createBy().concatenating().streams(new Publisher[]{(Publisher)sourceSupplier.apply(transaction), transaction.commit().toMulti().onItem().apply(aVoid -> aVoid)}).on().failure().recoverWithMulti(throwable -> transaction.rollback().on().failure().recoverWithItem((Object)null).on().item().produceMulti(v -> Multi.createFrom().failure(throwable)));
        });
    }

    public static <T> Uni<T> inTransactionUni(Pool pool, Function<SqlClient, Uni<T>> sourceSupplier) {
        return SqlClientHelper.usingConnectionUni(pool, conn -> {
            Transaction transaction = conn.begin();
            return ((Uni)sourceSupplier.apply(transaction)).onItem().produceUni(item -> transaction.commit().on().item().produceUni(v -> Uni.createFrom().item(item))).on().failure().recoverWithUni(throwable -> transaction.rollback().on().failure().recoverWithItem((Object)null).on().item().produceUni(v -> Uni.createFrom().failure(throwable)));
        });
    }

    public static <T> Multi<T> usingConnectionMulti(Pool pool, Function<SqlConnection, Multi<T>> sourceSupplier) {
        return pool.getConnection().onItem().produceMulti(conn -> {
            try {
                return ((Multi)sourceSupplier.apply((SqlConnection)conn)).on().termination(conn::close);
            }
            catch (Throwable t) {
                conn.close();
                return Multi.createFrom().failure(t);
            }
        });
    }

    public static <T> Uni<T> usingConnectionUni(Pool pool, Function<SqlConnection, Uni<T>> sourceSupplier) {
        return pool.getConnection().onItem().produceUni(conn -> {
            try {
                return ((Uni)sourceSupplier.apply((SqlConnection)conn)).on().termination(conn::close);
            }
            catch (Throwable t) {
                conn.close();
                return Uni.createFrom().failure(t);
            }
        });
    }

    private SqlClientHelper() {
    }
}

