/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.sqlclient;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.mutiny.sqlclient.PreparedQuery;
import io.vertx.mutiny.sqlclient.Row;
import io.vertx.mutiny.sqlclient.RowSet;
import io.vertx.mutiny.sqlclient.SqlClient;
import io.vertx.mutiny.sqlclient.Transaction;
import io.vertx.mutiny.sqlclient.Tuple;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

@MutinyGen(value=io.vertx.sqlclient.SqlConnection.class)
public class SqlConnection
extends SqlClient {
    public static final TypeArg<SqlConnection> __TYPE_ARG = new TypeArg(obj -> new SqlConnection((io.vertx.sqlclient.SqlConnection)obj), SqlConnection::getDelegate);
    private final io.vertx.sqlclient.SqlConnection delegate;

    public SqlConnection(io.vertx.sqlclient.SqlConnection delegate) {
        super((io.vertx.sqlclient.SqlClient)delegate);
        this.delegate = delegate;
    }

    SqlConnection() {
        super(null);
        this.delegate = null;
    }

    public io.vertx.sqlclient.SqlConnection getDelegate() {
        return this.delegate;
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlConnection that = (SqlConnection)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    private SqlConnection __prepare(String sql, final Handler<AsyncResult<PreparedQuery>> handler) {
        this.delegate.prepare(sql, (Handler)new Handler<AsyncResult<io.vertx.sqlclient.PreparedQuery>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.PreparedQuery> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)PreparedQuery.newInstance((io.vertx.sqlclient.PreparedQuery)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<PreparedQuery> prepare(String sql) {
        return AsyncResultUni.toUni(handler -> this.__prepare(sql, (Handler<AsyncResult<PreparedQuery>>)handler));
    }

    public PreparedQuery prepareAndAwait(String sql) {
        return (PreparedQuery)this.prepare(sql).await().indefinitely();
    }

    private SqlConnection __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public SqlConnection exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler(handler != null ? handler::accept : null);
    }

    private SqlConnection __closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public SqlConnection closeHandler(Consumer<Void> handler) {
        return this.__closeHandler(handler != null ? handler::accept : null);
    }

    public Transaction begin() {
        Transaction ret = Transaction.newInstance(this.delegate.begin());
        return ret;
    }

    public boolean isSSL() {
        boolean ret = this.delegate.isSSL();
        return ret;
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    private SqlConnection __preparedQuery(String sql, final Handler<AsyncResult<RowSet<Row>>> handler) {
        this.delegate.preparedQuery(sql, (Handler)new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(RowSet.newInstance((io.vertx.sqlclient.RowSet)ar.result(), Row.__TYPE_ARG)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Override
    public Uni<RowSet<Row>> preparedQuery(String sql) {
        return AsyncResultUni.toUni(handler -> this.__preparedQuery(sql, (Handler<AsyncResult<RowSet<Row>>>)handler));
    }

    @Override
    public RowSet<Row> preparedQueryAndAwait(String sql) {
        return (RowSet)this.preparedQuery(sql).await().indefinitely();
    }

    private SqlConnection __query(String sql, final Handler<AsyncResult<RowSet<Row>>> handler) {
        this.delegate.query(sql, (Handler)new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(RowSet.newInstance((io.vertx.sqlclient.RowSet)ar.result(), Row.__TYPE_ARG)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Override
    public Uni<RowSet<Row>> query(String sql) {
        return AsyncResultUni.toUni(handler -> this.__query(sql, (Handler<AsyncResult<RowSet<Row>>>)handler));
    }

    @Override
    public RowSet<Row> queryAndAwait(String sql) {
        return (RowSet)this.query(sql).await().indefinitely();
    }

    private SqlConnection __preparedQuery(String sql, Tuple arguments, final Handler<AsyncResult<RowSet<Row>>> handler) {
        this.delegate.preparedQuery(sql, arguments.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(RowSet.newInstance((io.vertx.sqlclient.RowSet)ar.result(), Row.__TYPE_ARG)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Override
    public Uni<RowSet<Row>> preparedQuery(String sql, Tuple arguments) {
        return AsyncResultUni.toUni(handler -> this.__preparedQuery(sql, arguments, (Handler<AsyncResult<RowSet<Row>>>)handler));
    }

    @Override
    public RowSet<Row> preparedQueryAndAwait(String sql, Tuple arguments) {
        return (RowSet)this.preparedQuery(sql, arguments).await().indefinitely();
    }

    private SqlConnection __preparedBatch(String sql, List<Tuple> batch, final Handler<AsyncResult<RowSet<Row>>> handler) {
        this.delegate.preparedBatch(sql, batch.stream().map(elt -> elt.getDelegate()).collect(Collectors.toList()), (Handler)new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(RowSet.newInstance((io.vertx.sqlclient.RowSet)ar.result(), Row.__TYPE_ARG)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Override
    public Uni<RowSet<Row>> preparedBatch(String sql, List<Tuple> batch) {
        return AsyncResultUni.toUni(handler -> this.__preparedBatch(sql, batch, (Handler<AsyncResult<RowSet<Row>>>)handler));
    }

    @Override
    public RowSet<Row> preparedBatchAndAwait(String sql, List<Tuple> batch) {
        return (RowSet)this.preparedBatch(sql, batch).await().indefinitely();
    }

    public static SqlConnection newInstance(io.vertx.sqlclient.SqlConnection arg) {
        return arg != null ? new SqlConnection(arg) : null;
    }
}

