/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.ext.shell;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.DelegatingConsumerHandler;
import io.smallrye.mutiny.vertx.DelegatingHandler;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.shell.ShellServerOptions;
import io.vertx.mutiny.ext.shell.Shell;
import io.vertx.mutiny.ext.shell.command.CommandResolver;
import io.vertx.mutiny.ext.shell.term.Term;
import io.vertx.mutiny.ext.shell.term.TermServer;
import java.util.function.Consumer;

@MutinyGen(value=io.vertx.ext.shell.ShellServer.class)
public class ShellServer {
    public static final TypeArg<ShellServer> __TYPE_ARG = new TypeArg(obj -> new ShellServer((io.vertx.ext.shell.ShellServer)obj), ShellServer::getDelegate);
    private final io.vertx.ext.shell.ShellServer delegate;

    public ShellServer(io.vertx.ext.shell.ShellServer delegate) {
        this.delegate = delegate;
    }

    public ShellServer(Object delegate) {
        this.delegate = (io.vertx.ext.shell.ShellServer)delegate;
    }

    ShellServer() {
        this.delegate = null;
    }

    public io.vertx.ext.shell.ShellServer getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShellServer that = (ShellServer)o;
        return this.delegate.equals((Object)that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static ShellServer create(io.vertx.mutiny.core.Vertx vertx, ShellServerOptions options) {
        ShellServer ret = ShellServer.newInstance(io.vertx.ext.shell.ShellServer.create((Vertx)vertx.getDelegate(), (ShellServerOptions)options));
        return ret;
    }

    public static ShellServer create(io.vertx.mutiny.core.Vertx vertx) {
        ShellServer ret = ShellServer.newInstance(io.vertx.ext.shell.ShellServer.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    @Fluent
    public ShellServer registerCommandResolver(CommandResolver resolver) {
        this.delegate.registerCommandResolver(resolver.getDelegate());
        return this;
    }

    @Fluent
    public ShellServer registerTermServer(TermServer termServer) {
        this.delegate.registerTermServer(termServer.getDelegate());
        return this;
    }

    public Shell createShell(Term term) {
        Shell ret = Shell.newInstance(this.delegate.createShell(term.getDelegate()));
        return ret;
    }

    public Shell createShell() {
        Shell ret = Shell.newInstance(this.delegate.createShell());
        return ret;
    }

    @CheckReturnValue
    public Uni<Void> listen() {
        return AsyncResultUni.toUni(listenHandler -> this.delegate.listen(listenHandler));
    }

    public Void listenAndAwait() {
        return (Void)this.listen().await().indefinitely();
    }

    @Fluent
    public ShellServer listenAndForget() {
        this.listen().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> close() {
        return AsyncResultUni.toUni(completionHandler -> this.delegate.close(completionHandler));
    }

    public Void closeAndAwait() {
        return (Void)this.close().await().indefinitely();
    }

    public void closeAndForget() {
        this.close().subscribe().with(UniHelper.NOOP);
    }

    private void __shellHandler(Handler<Shell> shellHandler) {
        this.delegate.shellHandler((Handler)new DelegatingHandler(shellHandler, event -> Shell.newInstance(event)));
    }

    public void shellHandler(Consumer<Shell> shellHandler) {
        this.__shellHandler((Handler<Shell>)(shellHandler != null ? new DelegatingConsumerHandler(shellHandler) : null));
    }

    public static ShellServer newInstance(io.vertx.ext.shell.ShellServer arg) {
        return arg != null ? new ShellServer(arg) : null;
    }
}

