/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.redis.client;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MultiHelper;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.net.SocketAddress;
import io.vertx.mutiny.core.streams.Pipe;
import io.vertx.mutiny.core.streams.ReadStream;
import io.vertx.mutiny.core.streams.WriteStream;
import io.vertx.mutiny.redis.client.Request;
import io.vertx.mutiny.redis.client.Response;
import io.vertx.redis.client.RedisOptions;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@MutinyGen(value=io.vertx.redis.client.Redis.class)
public class Redis
implements ReadStream<Response> {
    public static final TypeArg<Redis> __TYPE_ARG = new TypeArg(obj -> new Redis((io.vertx.redis.client.Redis)obj), Redis::getDelegate);
    private final io.vertx.redis.client.Redis delegate;
    private Multi<Response> multi;

    public Redis(io.vertx.redis.client.Redis delegate) {
        this.delegate = delegate;
    }

    Redis() {
        this.delegate = null;
    }

    public io.vertx.redis.client.Redis getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Redis that = (Redis)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public Pipe<Response> pipe() {
        Pipe ret = Pipe.newInstance((io.vertx.core.streams.Pipe)this.delegate.pipe(), Response.__TYPE_ARG);
        return ret;
    }

    private void __pipeTo(WriteStream<Response> dst, Handler<AsyncResult<Void>> handler) {
        this.delegate.pipeTo(dst.getDelegate(), handler);
    }

    public Uni<Void> pipeTo(WriteStream<Response> dst) {
        return AsyncResultUni.toUni(handler -> this.__pipeTo(dst, (Handler<AsyncResult<Void>>)handler));
    }

    public Void pipeToAndAwait(WriteStream<Response> dst) {
        return (Void)this.pipeTo(dst).await().indefinitely();
    }

    public static Redis createClient(io.vertx.mutiny.core.Vertx vertx, io.vertx.mutiny.core.net.SocketAddress address) {
        Redis ret = Redis.newInstance(io.vertx.redis.client.Redis.createClient((Vertx)vertx.getDelegate(), (SocketAddress)address.getDelegate()));
        return ret;
    }

    public static Redis createClient(io.vertx.mutiny.core.Vertx vertx, RedisOptions options) {
        Redis ret = Redis.newInstance(io.vertx.redis.client.Redis.createClient((Vertx)vertx.getDelegate(), (RedisOptions)options));
        return ret;
    }

    private Redis __connect(final Handler<AsyncResult<Redis>> handler) {
        this.delegate.connect((Handler)new Handler<AsyncResult<io.vertx.redis.client.Redis>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Redis> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Redis.newInstance((io.vertx.redis.client.Redis)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<Redis> connect() {
        return AsyncResultUni.toUni(handler -> this.__connect((Handler<AsyncResult<Redis>>)handler));
    }

    public Redis connectAndAwait() {
        return (Redis)this.connect().await().indefinitely();
    }

    private Redis __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public Redis exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler(handler != null ? handler::accept : null);
    }

    private Redis __handler(final Handler<Response> handler) {
        this.delegate.handler((Handler)new Handler<io.vertx.redis.client.Response>(){

            public void handle(io.vertx.redis.client.Response event) {
                handler.handle((Object)Response.newInstance(event));
            }
        });
        return this;
    }

    public Redis handler(Consumer<Response> handler) {
        return this.__handler(handler != null ? handler::accept : null);
    }

    public Redis pause() {
        this.delegate.pause();
        return this;
    }

    public Redis resume() {
        this.delegate.resume();
        return this;
    }

    public Redis fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    private Redis __endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public Redis endHandler(Consumer<Void> endHandler) {
        return this.__endHandler(endHandler != null ? endHandler::accept : null);
    }

    private Redis __send(Request command, final Handler<AsyncResult<Response>> onSend) {
        this.delegate.send(command.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    onSend.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    onSend.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<Response> send(Request command) {
        return AsyncResultUni.toUni(handler -> this.__send(command, (Handler<AsyncResult<Response>>)handler));
    }

    public Response sendAndAwait(Request command) {
        return (Response)this.send(command).await().indefinitely();
    }

    private Redis __batch(List<Request> commands, final Handler<AsyncResult<List<Response>>> handler) {
        this.delegate.batch(commands.stream().map(elt -> elt.getDelegate()).collect(Collectors.toList()), (Handler)new Handler<AsyncResult<List<io.vertx.redis.client.Response>>>(){

            public void handle(AsyncResult<List<io.vertx.redis.client.Response>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(((List)ar.result()).stream().map(elt -> Response.newInstance(elt)).collect(Collectors.toList())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<List<Response>> batch(List<Request> commands) {
        return AsyncResultUni.toUni(handler -> this.__batch(commands, (Handler<AsyncResult<List<Response>>>)handler));
    }

    public List<Response> batchAndAwait(List<Request> commands) {
        return (List)this.batch(commands).await().indefinitely();
    }

    public io.vertx.mutiny.core.net.SocketAddress socketAddress() {
        io.vertx.mutiny.core.net.SocketAddress ret = io.vertx.mutiny.core.net.SocketAddress.newInstance((SocketAddress)this.delegate.socketAddress());
        return ret;
    }

    public void close() {
        this.delegate.close();
    }

    public synchronized Multi<Response> toMulti() {
        if (this.multi == null) {
            Function<io.vertx.redis.client.Response, Response> conv = Response::newInstance;
            this.multi = MultiHelper.toMulti((io.vertx.core.streams.ReadStream)this.delegate, conv);
        }
        return this.multi;
    }

    public Iterable<Response> toBlockingIterable() {
        return this.toMulti().subscribe().asIterable();
    }

    public Stream<Response> toBlockingStream() {
        return this.toMulti().subscribe().asStream();
    }

    public static Redis newInstance(io.vertx.redis.client.Redis arg) {
        return arg != null ? new Redis(arg) : null;
    }
}

