/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.rabbitmq;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MultiHelper;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.mutiny.core.streams.Pipe;
import io.vertx.mutiny.core.streams.ReadStream;
import io.vertx.mutiny.core.streams.WriteStream;
import io.vertx.mutiny.rabbitmq.RabbitMQMessage;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

@MutinyGen(value=io.vertx.rabbitmq.RabbitMQConsumer.class)
public class RabbitMQConsumer
implements ReadStream<RabbitMQMessage> {
    public static final TypeArg<RabbitMQConsumer> __TYPE_ARG = new TypeArg(obj -> new RabbitMQConsumer((io.vertx.rabbitmq.RabbitMQConsumer)obj), RabbitMQConsumer::getDelegate);
    private final io.vertx.rabbitmq.RabbitMQConsumer delegate;
    private Multi<RabbitMQMessage> multi;

    public RabbitMQConsumer(io.vertx.rabbitmq.RabbitMQConsumer delegate) {
        this.delegate = delegate;
    }

    RabbitMQConsumer() {
        this.delegate = null;
    }

    public io.vertx.rabbitmq.RabbitMQConsumer getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RabbitMQConsumer that = (RabbitMQConsumer)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public ReadStream<RabbitMQMessage> fetch(long arg0) {
        this.delegate.fetch(arg0);
        return this;
    }

    public Pipe<RabbitMQMessage> pipe() {
        Pipe ret = Pipe.newInstance((io.vertx.core.streams.Pipe)this.delegate.pipe(), RabbitMQMessage.__TYPE_ARG);
        return ret;
    }

    private void __pipeTo(WriteStream<RabbitMQMessage> dst, Handler<AsyncResult<Void>> handler) {
        this.delegate.pipeTo(dst.getDelegate(), handler);
    }

    public Uni<Void> pipeTo(WriteStream<RabbitMQMessage> dst) {
        return AsyncResultUni.toUni(handler -> this.__pipeTo(dst, (Handler<AsyncResult<Void>>)handler));
    }

    public Void pipeToAndAwait(WriteStream<RabbitMQMessage> dst) {
        return (Void)this.pipeTo(dst).await().indefinitely();
    }

    private RabbitMQConsumer __exceptionHandler(Handler<Throwable> exceptionHandler) {
        this.delegate.exceptionHandler(exceptionHandler);
        return this;
    }

    public RabbitMQConsumer exceptionHandler(Consumer<Throwable> exceptionHandler) {
        return this.__exceptionHandler(exceptionHandler != null ? exceptionHandler::accept : null);
    }

    private RabbitMQConsumer __handler(final Handler<RabbitMQMessage> messageArrived) {
        this.delegate.handler((Handler)new Handler<io.vertx.rabbitmq.RabbitMQMessage>(){

            public void handle(io.vertx.rabbitmq.RabbitMQMessage event) {
                messageArrived.handle((Object)RabbitMQMessage.newInstance(event));
            }
        });
        return this;
    }

    public RabbitMQConsumer handler(Consumer<RabbitMQMessage> messageArrived) {
        return this.__handler(messageArrived != null ? messageArrived::accept : null);
    }

    public RabbitMQConsumer pause() {
        this.delegate.pause();
        return this;
    }

    public RabbitMQConsumer resume() {
        this.delegate.resume();
        return this;
    }

    private RabbitMQConsumer __endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public RabbitMQConsumer endHandler(Consumer<Void> endHandler) {
        return this.__endHandler(endHandler != null ? endHandler::accept : null);
    }

    public String consumerTag() {
        String ret = this.delegate.consumerTag();
        return ret;
    }

    private void __cancel(Handler<AsyncResult<Void>> cancelResult) {
        this.delegate.cancel(cancelResult);
    }

    public Uni<Void> cancel() {
        return AsyncResultUni.toUni(handler -> this.__cancel((Handler<AsyncResult<Void>>)handler));
    }

    public Void cancelAndAwait() {
        return (Void)this.cancel().await().indefinitely();
    }

    public boolean isPaused() {
        boolean ret = this.delegate.isPaused();
        return ret;
    }

    public void pipeToAndForget(WriteStream<RabbitMQMessage> dst) {
        this.delegate.pipeTo(dst.getDelegate());
    }

    public void cancelAndForget() {
        this.delegate.cancel();
    }

    public synchronized Multi<RabbitMQMessage> toMulti() {
        if (this.multi == null) {
            Function<io.vertx.rabbitmq.RabbitMQMessage, RabbitMQMessage> conv = RabbitMQMessage::newInstance;
            this.multi = MultiHelper.toMulti((io.vertx.core.streams.ReadStream)this.delegate, conv);
        }
        return this.multi;
    }

    public Iterable<RabbitMQMessage> toBlockingIterable() {
        return this.toMulti().subscribe().asIterable();
    }

    public Stream<RabbitMQMessage> toBlockingStream() {
        return this.toMulti().subscribe().asStream();
    }

    public static RabbitMQConsumer newInstance(io.vertx.rabbitmq.RabbitMQConsumer arg) {
        return arg != null ? new RabbitMQConsumer(arg) : null;
    }
}

