/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.rabbitmq;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.mutiny.rabbitmq.RabbitMQConsumer;
import io.vertx.rabbitmq.QueueOptions;
import io.vertx.rabbitmq.RabbitMQOptions;
import java.util.function.Consumer;

@MutinyGen(value=io.vertx.rabbitmq.RabbitMQClient.class)
public class RabbitMQClient {
    public static final TypeArg<RabbitMQClient> __TYPE_ARG = new TypeArg(obj -> new RabbitMQClient((io.vertx.rabbitmq.RabbitMQClient)obj), RabbitMQClient::getDelegate);
    private final io.vertx.rabbitmq.RabbitMQClient delegate;

    public RabbitMQClient(io.vertx.rabbitmq.RabbitMQClient delegate) {
        this.delegate = delegate;
    }

    RabbitMQClient() {
        this.delegate = null;
    }

    public io.vertx.rabbitmq.RabbitMQClient getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RabbitMQClient that = (RabbitMQClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static RabbitMQClient create(io.vertx.mutiny.core.Vertx vertx) {
        RabbitMQClient ret = RabbitMQClient.newInstance(io.vertx.rabbitmq.RabbitMQClient.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static RabbitMQClient create(io.vertx.mutiny.core.Vertx vertx, RabbitMQOptions config) {
        RabbitMQClient ret = RabbitMQClient.newInstance(io.vertx.rabbitmq.RabbitMQClient.create((Vertx)vertx.getDelegate(), (RabbitMQOptions)config));
        return ret;
    }

    private void __basicAck(long deliveryTag, boolean multiple, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.basicAck(deliveryTag, multiple, resultHandler);
    }

    public Uni<JsonObject> basicAck(long deliveryTag, boolean multiple) {
        return AsyncResultUni.toUni(handler -> this.__basicAck(deliveryTag, multiple, (Handler<AsyncResult<JsonObject>>)handler));
    }

    public JsonObject basicAckAndAwait(long deliveryTag, boolean multiple) {
        return (JsonObject)this.basicAck(deliveryTag, multiple).await().indefinitely();
    }

    private void __basicNack(long deliveryTag, boolean multiple, boolean requeue, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.basicNack(deliveryTag, multiple, requeue, resultHandler);
    }

    public Uni<JsonObject> basicNack(long deliveryTag, boolean multiple, boolean requeue) {
        return AsyncResultUni.toUni(handler -> this.__basicNack(deliveryTag, multiple, requeue, (Handler<AsyncResult<JsonObject>>)handler));
    }

    public JsonObject basicNackAndAwait(long deliveryTag, boolean multiple, boolean requeue) {
        return (JsonObject)this.basicNack(deliveryTag, multiple, requeue).await().indefinitely();
    }

    private void __basicGet(String queue, boolean autoAck, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.basicGet(queue, autoAck, resultHandler);
    }

    public Uni<JsonObject> basicGet(String queue, boolean autoAck) {
        return AsyncResultUni.toUni(handler -> this.__basicGet(queue, autoAck, (Handler<AsyncResult<JsonObject>>)handler));
    }

    public JsonObject basicGetAndAwait(String queue, boolean autoAck) {
        return (JsonObject)this.basicGet(queue, autoAck).await().indefinitely();
    }

    @Deprecated
    private void __basicConsume(String queue, String address, Handler<AsyncResult<String>> resultHandler) {
        this.delegate.basicConsume(queue, address, resultHandler);
    }

    @Deprecated
    public Uni<String> basicConsume(String queue, String address) {
        return AsyncResultUni.toUni(handler -> this.__basicConsume(queue, address, (Handler<AsyncResult<String>>)handler));
    }

    @Deprecated
    public String basicConsumeAndAwait(String queue, String address) {
        return (String)this.basicConsume(queue, address).await().indefinitely();
    }

    @Deprecated
    private void __basicConsume(String queue, String address, boolean autoAck, Handler<AsyncResult<String>> resultHandler) {
        this.delegate.basicConsume(queue, address, autoAck, resultHandler);
    }

    @Deprecated
    public Uni<String> basicConsume(String queue, String address, boolean autoAck) {
        return AsyncResultUni.toUni(handler -> this.__basicConsume(queue, address, autoAck, (Handler<AsyncResult<String>>)handler));
    }

    @Deprecated
    public String basicConsumeAndAwait(String queue, String address, boolean autoAck) {
        return (String)this.basicConsume(queue, address, autoAck).await().indefinitely();
    }

    @Deprecated
    private void __basicConsume(String queue, String address, boolean autoAck, Handler<AsyncResult<String>> resultHandler, Handler<Throwable> errorHandler) {
        this.delegate.basicConsume(queue, address, autoAck, resultHandler, errorHandler);
    }

    @Deprecated
    public void basicConsume(String queue, String address, boolean autoAck, Handler<AsyncResult<String>> resultHandler, Consumer<Throwable> errorHandler) {
        this.__basicConsume(queue, address, autoAck, resultHandler, errorHandler != null ? errorHandler::accept : null);
    }

    @Deprecated
    private void __basicCancel(String consumerTag, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicCancel(consumerTag, resultHandler);
    }

    @Deprecated
    public Uni<Void> basicCancel(String consumerTag) {
        return AsyncResultUni.toUni(handler -> this.__basicCancel(consumerTag, (Handler<AsyncResult<Void>>)handler));
    }

    @Deprecated
    public Void basicCancelAndAwait(String consumerTag) {
        return (Void)this.basicCancel(consumerTag).await().indefinitely();
    }

    private void __basicConsumer(String queue, final Handler<AsyncResult<RabbitMQConsumer>> resultHandler) {
        this.delegate.basicConsumer(queue, (Handler)new Handler<AsyncResult<io.vertx.rabbitmq.RabbitMQConsumer>>(){

            public void handle(AsyncResult<io.vertx.rabbitmq.RabbitMQConsumer> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)RabbitMQConsumer.newInstance((io.vertx.rabbitmq.RabbitMQConsumer)ar.result())));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Uni<RabbitMQConsumer> basicConsumer(String queue) {
        return AsyncResultUni.toUni(handler -> this.__basicConsumer(queue, (Handler<AsyncResult<RabbitMQConsumer>>)handler));
    }

    public RabbitMQConsumer basicConsumerAndAwait(String queue) {
        return (RabbitMQConsumer)this.basicConsumer(queue).await().indefinitely();
    }

    private void __basicConsumer(String queue, QueueOptions options, final Handler<AsyncResult<RabbitMQConsumer>> resultHandler) {
        this.delegate.basicConsumer(queue, options, (Handler)new Handler<AsyncResult<io.vertx.rabbitmq.RabbitMQConsumer>>(){

            public void handle(AsyncResult<io.vertx.rabbitmq.RabbitMQConsumer> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)RabbitMQConsumer.newInstance((io.vertx.rabbitmq.RabbitMQConsumer)ar.result())));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Uni<RabbitMQConsumer> basicConsumer(String queue, QueueOptions options) {
        return AsyncResultUni.toUni(handler -> this.__basicConsumer(queue, options, (Handler<AsyncResult<RabbitMQConsumer>>)handler));
    }

    public RabbitMQConsumer basicConsumerAndAwait(String queue, QueueOptions options) {
        return (RabbitMQConsumer)this.basicConsumer(queue, options).await().indefinitely();
    }

    private void __basicPublish(String exchange, String routingKey, JsonObject message, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicPublish(exchange, routingKey, message, resultHandler);
    }

    public Uni<Void> basicPublish(String exchange, String routingKey, JsonObject message) {
        return AsyncResultUni.toUni(handler -> this.__basicPublish(exchange, routingKey, message, (Handler<AsyncResult<Void>>)handler));
    }

    public Void basicPublishAndAwait(String exchange, String routingKey, JsonObject message) {
        return (Void)this.basicPublish(exchange, routingKey, message).await().indefinitely();
    }

    private void __confirmSelect(Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.confirmSelect(resultHandler);
    }

    public Uni<Void> confirmSelect() {
        return AsyncResultUni.toUni(handler -> this.__confirmSelect((Handler<AsyncResult<Void>>)handler));
    }

    public Void confirmSelectAndAwait() {
        return (Void)this.confirmSelect().await().indefinitely();
    }

    private void __waitForConfirms(Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.waitForConfirms(resultHandler);
    }

    public Uni<Void> waitForConfirms() {
        return AsyncResultUni.toUni(handler -> this.__waitForConfirms((Handler<AsyncResult<Void>>)handler));
    }

    public Void waitForConfirmsAndAwait() {
        return (Void)this.waitForConfirms().await().indefinitely();
    }

    private void __waitForConfirms(long timeout, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.waitForConfirms(timeout, resultHandler);
    }

    public Uni<Void> waitForConfirms(long timeout) {
        return AsyncResultUni.toUni(handler -> this.__waitForConfirms(timeout, (Handler<AsyncResult<Void>>)handler));
    }

    public Void waitForConfirmsAndAwait(long timeout) {
        return (Void)this.waitForConfirms(timeout).await().indefinitely();
    }

    private void __basicQos(int prefetchCount, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicQos(prefetchCount, resultHandler);
    }

    public Uni<Void> basicQos(int prefetchCount) {
        return AsyncResultUni.toUni(handler -> this.__basicQos(prefetchCount, (Handler<AsyncResult<Void>>)handler));
    }

    public Void basicQosAndAwait(int prefetchCount) {
        return (Void)this.basicQos(prefetchCount).await().indefinitely();
    }

    private void __basicQos(int prefetchCount, boolean global, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicQos(prefetchCount, global, resultHandler);
    }

    public Uni<Void> basicQos(int prefetchCount, boolean global) {
        return AsyncResultUni.toUni(handler -> this.__basicQos(prefetchCount, global, (Handler<AsyncResult<Void>>)handler));
    }

    public Void basicQosAndAwait(int prefetchCount, boolean global) {
        return (Void)this.basicQos(prefetchCount, global).await().indefinitely();
    }

    private void __basicQos(int prefetchSize, int prefetchCount, boolean global, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicQos(prefetchSize, prefetchCount, global, resultHandler);
    }

    public Uni<Void> basicQos(int prefetchSize, int prefetchCount, boolean global) {
        return AsyncResultUni.toUni(handler -> this.__basicQos(prefetchSize, prefetchCount, global, (Handler<AsyncResult<Void>>)handler));
    }

    public Void basicQosAndAwait(int prefetchSize, int prefetchCount, boolean global) {
        return (Void)this.basicQos(prefetchSize, prefetchCount, global).await().indefinitely();
    }

    private void __exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeDeclare(exchange, type, durable, autoDelete, resultHandler);
    }

    public Uni<Void> exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete) {
        return AsyncResultUni.toUni(handler -> this.__exchangeDeclare(exchange, type, durable, autoDelete, (Handler<AsyncResult<Void>>)handler));
    }

    public Void exchangeDeclareAndAwait(String exchange, String type, boolean durable, boolean autoDelete) {
        return (Void)this.exchangeDeclare(exchange, type, durable, autoDelete).await().indefinitely();
    }

    private void __exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, JsonObject config, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeDeclare(exchange, type, durable, autoDelete, config, resultHandler);
    }

    public Uni<Void> exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, JsonObject config) {
        return AsyncResultUni.toUni(handler -> this.__exchangeDeclare(exchange, type, durable, autoDelete, config, (Handler<AsyncResult<Void>>)handler));
    }

    public Void exchangeDeclareAndAwait(String exchange, String type, boolean durable, boolean autoDelete, JsonObject config) {
        return (Void)this.exchangeDeclare(exchange, type, durable, autoDelete, config).await().indefinitely();
    }

    private void __exchangeDelete(String exchange, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeDelete(exchange, resultHandler);
    }

    public Uni<Void> exchangeDelete(String exchange) {
        return AsyncResultUni.toUni(handler -> this.__exchangeDelete(exchange, (Handler<AsyncResult<Void>>)handler));
    }

    public Void exchangeDeleteAndAwait(String exchange) {
        return (Void)this.exchangeDelete(exchange).await().indefinitely();
    }

    private void __exchangeBind(String destination, String source, String routingKey, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeBind(destination, source, routingKey, resultHandler);
    }

    public Uni<Void> exchangeBind(String destination, String source, String routingKey) {
        return AsyncResultUni.toUni(handler -> this.__exchangeBind(destination, source, routingKey, (Handler<AsyncResult<Void>>)handler));
    }

    public Void exchangeBindAndAwait(String destination, String source, String routingKey) {
        return (Void)this.exchangeBind(destination, source, routingKey).await().indefinitely();
    }

    private void __exchangeUnbind(String destination, String source, String routingKey, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeUnbind(destination, source, routingKey, resultHandler);
    }

    public Uni<Void> exchangeUnbind(String destination, String source, String routingKey) {
        return AsyncResultUni.toUni(handler -> this.__exchangeUnbind(destination, source, routingKey, (Handler<AsyncResult<Void>>)handler));
    }

    public Void exchangeUnbindAndAwait(String destination, String source, String routingKey) {
        return (Void)this.exchangeUnbind(destination, source, routingKey).await().indefinitely();
    }

    private void __queueDeclareAuto(Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.queueDeclareAuto(resultHandler);
    }

    public Uni<JsonObject> queueDeclareAuto() {
        return AsyncResultUni.toUni(handler -> this.__queueDeclareAuto((Handler<AsyncResult<JsonObject>>)handler));
    }

    public JsonObject queueDeclareAutoAndAwait() {
        return (JsonObject)this.queueDeclareAuto().await().indefinitely();
    }

    private void __queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.queueDeclare(queue, durable, exclusive, autoDelete, resultHandler);
    }

    public Uni<JsonObject> queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete) {
        return AsyncResultUni.toUni(handler -> this.__queueDeclare(queue, durable, exclusive, autoDelete, (Handler<AsyncResult<JsonObject>>)handler));
    }

    public JsonObject queueDeclareAndAwait(String queue, boolean durable, boolean exclusive, boolean autoDelete) {
        return (JsonObject)this.queueDeclare(queue, durable, exclusive, autoDelete).await().indefinitely();
    }

    private void __queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, JsonObject config, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.queueDeclare(queue, durable, exclusive, autoDelete, config, resultHandler);
    }

    public Uni<JsonObject> queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, JsonObject config) {
        return AsyncResultUni.toUni(handler -> this.__queueDeclare(queue, durable, exclusive, autoDelete, config, (Handler<AsyncResult<JsonObject>>)handler));
    }

    public JsonObject queueDeclareAndAwait(String queue, boolean durable, boolean exclusive, boolean autoDelete, JsonObject config) {
        return (JsonObject)this.queueDeclare(queue, durable, exclusive, autoDelete, config).await().indefinitely();
    }

    private void __queueDelete(String queue, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.queueDelete(queue, resultHandler);
    }

    public Uni<JsonObject> queueDelete(String queue) {
        return AsyncResultUni.toUni(handler -> this.__queueDelete(queue, (Handler<AsyncResult<JsonObject>>)handler));
    }

    public JsonObject queueDeleteAndAwait(String queue) {
        return (JsonObject)this.queueDelete(queue).await().indefinitely();
    }

    private void __queueDeleteIf(String queue, boolean ifUnused, boolean ifEmpty, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.queueDeleteIf(queue, ifUnused, ifEmpty, resultHandler);
    }

    public Uni<JsonObject> queueDeleteIf(String queue, boolean ifUnused, boolean ifEmpty) {
        return AsyncResultUni.toUni(handler -> this.__queueDeleteIf(queue, ifUnused, ifEmpty, (Handler<AsyncResult<JsonObject>>)handler));
    }

    public JsonObject queueDeleteIfAndAwait(String queue, boolean ifUnused, boolean ifEmpty) {
        return (JsonObject)this.queueDeleteIf(queue, ifUnused, ifEmpty).await().indefinitely();
    }

    private void __queueBind(String queue, String exchange, String routingKey, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.queueBind(queue, exchange, routingKey, resultHandler);
    }

    public Uni<Void> queueBind(String queue, String exchange, String routingKey) {
        return AsyncResultUni.toUni(handler -> this.__queueBind(queue, exchange, routingKey, (Handler<AsyncResult<Void>>)handler));
    }

    public Void queueBindAndAwait(String queue, String exchange, String routingKey) {
        return (Void)this.queueBind(queue, exchange, routingKey).await().indefinitely();
    }

    private void __messageCount(String queue, Handler<AsyncResult<Long>> resultHandler) {
        this.delegate.messageCount(queue, resultHandler);
    }

    public Uni<Long> messageCount(String queue) {
        return AsyncResultUni.toUni(handler -> this.__messageCount(queue, (Handler<AsyncResult<Long>>)handler));
    }

    public Long messageCountAndAwait(String queue) {
        return (Long)this.messageCount(queue).await().indefinitely();
    }

    private void __start(Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.start(resultHandler);
    }

    public Uni<Void> start() {
        return AsyncResultUni.toUni(handler -> this.__start((Handler<AsyncResult<Void>>)handler));
    }

    public Void startAndAwait() {
        return (Void)this.start().await().indefinitely();
    }

    private void __stop(Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.stop(resultHandler);
    }

    public Uni<Void> stop() {
        return AsyncResultUni.toUni(handler -> this.__stop((Handler<AsyncResult<Void>>)handler));
    }

    public Void stopAndAwait() {
        return (Void)this.stop().await().indefinitely();
    }

    public boolean isConnected() {
        boolean ret = this.delegate.isConnected();
        return ret;
    }

    public boolean isOpenChannel() {
        boolean ret = this.delegate.isOpenChannel();
        return ret;
    }

    @Deprecated
    public void basicCancelAndForget(String consumerTag) {
        this.delegate.basicCancel(consumerTag);
    }

    public static RabbitMQClient newInstance(io.vertx.rabbitmq.RabbitMQClient arg) {
        return arg != null ? new RabbitMQClient(arg) : null;
    }
}

