/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.openapi.validation;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.MutinyDelegate;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.mutiny.core.http.HttpServerRequest;
import io.vertx.mutiny.openapi.contract.OpenAPIContract;
import io.vertx.mutiny.openapi.validation.ValidatableRequest;
import io.vertx.mutiny.openapi.validation.ValidatedRequest;

@MutinyGen(value=io.vertx.openapi.validation.RequestValidator.class)
public class RequestValidator
implements MutinyDelegate {
    public static final TypeArg<RequestValidator> __TYPE_ARG = new TypeArg(obj -> new RequestValidator((io.vertx.openapi.validation.RequestValidator)obj), RequestValidator::getDelegate);
    private final io.vertx.openapi.validation.RequestValidator delegate;
    static final TypeArg<ValidatedRequest> TYPE_ARG_0 = new TypeArg(o1 -> ValidatedRequest.newInstance((io.vertx.openapi.validation.ValidatedRequest)o1), o1 -> o1.getDelegate());
    static final TypeArg<ValidatedRequest> TYPE_ARG_1 = new TypeArg(o1 -> ValidatedRequest.newInstance((io.vertx.openapi.validation.ValidatedRequest)o1), o1 -> o1.getDelegate());
    static final TypeArg<ValidatedRequest> TYPE_ARG_2 = new TypeArg(o1 -> ValidatedRequest.newInstance((io.vertx.openapi.validation.ValidatedRequest)o1), o1 -> o1.getDelegate());

    public RequestValidator(io.vertx.openapi.validation.RequestValidator delegate) {
        this.delegate = delegate;
    }

    public RequestValidator(Object delegate) {
        this.delegate = (io.vertx.openapi.validation.RequestValidator)delegate;
    }

    RequestValidator() {
        this.delegate = null;
    }

    public io.vertx.openapi.validation.RequestValidator getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestValidator that = (RequestValidator)o;
        return this.delegate.equals((Object)that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static RequestValidator create(io.vertx.mutiny.core.Vertx vertx, OpenAPIContract contract) {
        RequestValidator ret = RequestValidator.newInstance(io.vertx.openapi.validation.RequestValidator.create((Vertx)vertx.getDelegate(), (io.vertx.openapi.contract.OpenAPIContract)contract.getDelegate()));
        return ret;
    }

    @CheckReturnValue
    public Uni<ValidatedRequest> validate(HttpServerRequest request) {
        return UniHelper.toUni((Future)this.delegate.validate(request.getDelegate()).map(x -> ValidatedRequest.newInstance(x)));
    }

    public ValidatedRequest validateAndAwait(HttpServerRequest request) {
        return (ValidatedRequest)this.validate(request).await().indefinitely();
    }

    public void validateAndForget(HttpServerRequest request) {
        this.validate(request).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<ValidatedRequest> validate(HttpServerRequest request, String operationId) {
        return UniHelper.toUni((Future)this.delegate.validate(request.getDelegate(), operationId).map(x -> ValidatedRequest.newInstance(x)));
    }

    public ValidatedRequest validateAndAwait(HttpServerRequest request, String operationId) {
        return (ValidatedRequest)this.validate(request, operationId).await().indefinitely();
    }

    public void validateAndForget(HttpServerRequest request, String operationId) {
        this.validate(request, operationId).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<ValidatedRequest> validate(ValidatableRequest params, String operationId) {
        return UniHelper.toUni((Future)this.delegate.validate(params.getDelegate(), operationId).map(x -> ValidatedRequest.newInstance(x)));
    }

    public ValidatedRequest validateAndAwait(ValidatableRequest params, String operationId) {
        return (ValidatedRequest)this.validate(params, operationId).await().indefinitely();
    }

    public void validateAndForget(ValidatableRequest params, String operationId) {
        this.validate(params, operationId).subscribe().with(UniHelper.NOOP);
    }

    public static RequestValidator newInstance(io.vertx.openapi.validation.RequestValidator arg) {
        return arg != null ? new RequestValidator(arg) : null;
    }
}

