/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.mqtt;

import io.netty.handler.codec.mqtt.MqttQoS;
import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.DelegatingConsumerHandler;
import io.smallrye.mutiny.vertx.DelegatingHandler;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.mqtt.MqttClientOptions;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.mqtt.messages.MqttConnAckMessage;
import io.vertx.mutiny.mqtt.messages.MqttPublishMessage;
import io.vertx.mutiny.mqtt.messages.MqttSubAckMessage;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

@MutinyGen(value=io.vertx.mqtt.MqttClient.class)
public class MqttClient {
    public static final TypeArg<MqttClient> __TYPE_ARG = new TypeArg(obj -> new MqttClient((io.vertx.mqtt.MqttClient)obj), MqttClient::getDelegate);
    private final io.vertx.mqtt.MqttClient delegate;

    public MqttClient(io.vertx.mqtt.MqttClient delegate) {
        this.delegate = delegate;
    }

    public MqttClient(Object delegate) {
        this.delegate = (io.vertx.mqtt.MqttClient)delegate;
    }

    MqttClient() {
        this.delegate = null;
    }

    public io.vertx.mqtt.MqttClient getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MqttClient that = (MqttClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static MqttClient create(io.vertx.mutiny.core.Vertx vertx, MqttClientOptions options) {
        MqttClient ret = MqttClient.newInstance(io.vertx.mqtt.MqttClient.create((Vertx)vertx.getDelegate(), (MqttClientOptions)options));
        return ret;
    }

    public static MqttClient create(io.vertx.mutiny.core.Vertx vertx) {
        MqttClient ret = MqttClient.newInstance(io.vertx.mqtt.MqttClient.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    @CheckReturnValue
    public Uni<MqttConnAckMessage> connect(int port, String host) {
        return AsyncResultUni.toUni(connectHandler -> this.delegate.connect(port, host, (Handler)new DelegatingHandler(connectHandler, ar -> ar.map(event -> MqttConnAckMessage.newInstance(event)))));
    }

    public MqttConnAckMessage connectAndAwait(int port, String host) {
        return (MqttConnAckMessage)this.connect(port, host).await().indefinitely();
    }

    @Fluent
    public MqttClient connectAndForget(int port, String host) {
        this.connect(port, host).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<MqttConnAckMessage> connect(int port, String host, String serverName) {
        return AsyncResultUni.toUni(connectHandler -> this.delegate.connect(port, host, serverName, (Handler)new DelegatingHandler(connectHandler, ar -> ar.map(event -> MqttConnAckMessage.newInstance(event)))));
    }

    public MqttConnAckMessage connectAndAwait(int port, String host, String serverName) {
        return (MqttConnAckMessage)this.connect(port, host, serverName).await().indefinitely();
    }

    @Fluent
    public MqttClient connectAndForget(int port, String host, String serverName) {
        this.connect(port, host, serverName).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> disconnect() {
        return AsyncResultUni.toUni(disconnectHandler -> this.delegate.disconnect(disconnectHandler));
    }

    public Void disconnectAndAwait() {
        return (Void)this.disconnect().await().indefinitely();
    }

    @Fluent
    public MqttClient disconnectAndForget() {
        this.disconnect().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Integer> publish(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain) {
        return AsyncResultUni.toUni(publishSentHandler -> this.delegate.publish(topic, payload.getDelegate(), qosLevel, isDup, isRetain, publishSentHandler));
    }

    public Integer publishAndAwait(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain) {
        return (Integer)this.publish(topic, payload, qosLevel, isDup, isRetain).await().indefinitely();
    }

    @Fluent
    public MqttClient publishAndForget(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain) {
        this.publish(topic, payload, qosLevel, isDup, isRetain).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Fluent
    private MqttClient __publishCompletionHandler(Handler<Integer> publishCompletionHandler) {
        this.delegate.publishCompletionHandler(publishCompletionHandler);
        return this;
    }

    public MqttClient publishCompletionHandler(Consumer<Integer> publishCompletionHandler) {
        return this.__publishCompletionHandler((Handler<Integer>)(publishCompletionHandler != null ? new DelegatingConsumerHandler(publishCompletionHandler) : null));
    }

    @Fluent
    private MqttClient __publishCompletionExpirationHandler(Handler<Integer> publishCompletionExpirationHandler) {
        this.delegate.publishCompletionExpirationHandler(publishCompletionExpirationHandler);
        return this;
    }

    public MqttClient publishCompletionExpirationHandler(Consumer<Integer> publishCompletionExpirationHandler) {
        return this.__publishCompletionExpirationHandler((Handler<Integer>)(publishCompletionExpirationHandler != null ? new DelegatingConsumerHandler(publishCompletionExpirationHandler) : null));
    }

    @Fluent
    private MqttClient __publishCompletionUnknownPacketIdHandler(Handler<Integer> publishCompletionPhantomHandler) {
        this.delegate.publishCompletionUnknownPacketIdHandler(publishCompletionPhantomHandler);
        return this;
    }

    public MqttClient publishCompletionUnknownPacketIdHandler(Consumer<Integer> publishCompletionPhantomHandler) {
        return this.__publishCompletionUnknownPacketIdHandler((Handler<Integer>)(publishCompletionPhantomHandler != null ? new DelegatingConsumerHandler(publishCompletionPhantomHandler) : null));
    }

    @Fluent
    private MqttClient __publishHandler(Handler<MqttPublishMessage> publishHandler) {
        this.delegate.publishHandler((Handler)new DelegatingHandler(publishHandler, event -> MqttPublishMessage.newInstance(event)));
        return this;
    }

    public MqttClient publishHandler(Consumer<MqttPublishMessage> publishHandler) {
        return this.__publishHandler((Handler<MqttPublishMessage>)(publishHandler != null ? new DelegatingConsumerHandler(publishHandler) : null));
    }

    @Fluent
    private MqttClient __subscribeCompletionHandler(Handler<MqttSubAckMessage> subscribeCompletionHandler) {
        this.delegate.subscribeCompletionHandler((Handler)new DelegatingHandler(subscribeCompletionHandler, event -> MqttSubAckMessage.newInstance(event)));
        return this;
    }

    public MqttClient subscribeCompletionHandler(Consumer<MqttSubAckMessage> subscribeCompletionHandler) {
        return this.__subscribeCompletionHandler((Handler<MqttSubAckMessage>)(subscribeCompletionHandler != null ? new DelegatingConsumerHandler(subscribeCompletionHandler) : null));
    }

    @CheckReturnValue
    public Uni<Integer> subscribe(String topic, int qos) {
        return AsyncResultUni.toUni(subscribeSentHandler -> this.delegate.subscribe(topic, qos, subscribeSentHandler));
    }

    public Integer subscribeAndAwait(String topic, int qos) {
        return (Integer)this.subscribe(topic, qos).await().indefinitely();
    }

    @Fluent
    public MqttClient subscribeAndForget(String topic, int qos) {
        this.subscribe(topic, qos).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Integer> subscribe(Map<String, Integer> topics) {
        return AsyncResultUni.toUni(subscribeSentHandler -> this.delegate.subscribe(topics, subscribeSentHandler));
    }

    public Integer subscribeAndAwait(Map<String, Integer> topics) {
        return (Integer)this.subscribe(topics).await().indefinitely();
    }

    @Fluent
    public MqttClient subscribeAndForget(Map<String, Integer> topics) {
        this.subscribe(topics).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Fluent
    private MqttClient __unsubscribeCompletionHandler(Handler<Integer> unsubscribeCompletionHandler) {
        this.delegate.unsubscribeCompletionHandler(unsubscribeCompletionHandler);
        return this;
    }

    public MqttClient unsubscribeCompletionHandler(Consumer<Integer> unsubscribeCompletionHandler) {
        return this.__unsubscribeCompletionHandler((Handler<Integer>)(unsubscribeCompletionHandler != null ? new DelegatingConsumerHandler(unsubscribeCompletionHandler) : null));
    }

    @CheckReturnValue
    public Uni<Integer> unsubscribe(List<String> topics) {
        return AsyncResultUni.toUni(unsubscribeSentHandler -> this.delegate.unsubscribe(topics, unsubscribeSentHandler));
    }

    public Integer unsubscribeAndAwait(List<String> topics) {
        return (Integer)this.unsubscribe(topics).await().indefinitely();
    }

    @Fluent
    public MqttClient unsubscribeAndForget(List<String> topics) {
        this.unsubscribe(topics).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Integer> unsubscribe(String topic) {
        return AsyncResultUni.toUni(unsubscribeSentHandler -> this.delegate.unsubscribe(topic, unsubscribeSentHandler));
    }

    public Integer unsubscribeAndAwait(String topic) {
        return (Integer)this.unsubscribe(topic).await().indefinitely();
    }

    @Fluent
    public MqttClient unsubscribeAndForget(String topic) {
        this.unsubscribe(topic).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Fluent
    private MqttClient __pingResponseHandler(Handler<Void> pingResponseHandler) {
        this.delegate.pingResponseHandler(pingResponseHandler);
        return this;
    }

    public MqttClient pingResponseHandler(Runnable pingResponseHandler) {
        return this.__pingResponseHandler((Handler<Void>)((Handler)ignored -> pingResponseHandler.run()));
    }

    @Fluent
    private MqttClient __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public MqttClient exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler((Handler<Throwable>)(handler != null ? new DelegatingConsumerHandler(handler) : null));
    }

    @Fluent
    private MqttClient __closeHandler(Handler<Void> closeHandler) {
        this.delegate.closeHandler(closeHandler);
        return this;
    }

    public MqttClient closeHandler(Runnable closeHandler) {
        return this.__closeHandler((Handler<Void>)((Handler)ignored -> closeHandler.run()));
    }

    @Fluent
    public MqttClient ping() {
        this.delegate.ping();
        return this;
    }

    public String clientId() {
        String ret = this.delegate.clientId();
        return ret;
    }

    public boolean isConnected() {
        boolean ret = this.delegate.isConnected();
        return ret;
    }

    public static MqttClient newInstance(io.vertx.mqtt.MqttClient arg) {
        return arg != null ? new MqttClient(arg) : null;
    }
}

