/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.ext.sql;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.DelegatingHandler;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.UpdateResult;
import io.vertx.mutiny.ext.sql.SQLOperations;
import io.vertx.mutiny.ext.sql.SQLRowStream;

class SQLOperationsImpl
implements SQLOperations {
    private final io.vertx.ext.sql.SQLOperations delegate;

    @Override
    public io.vertx.ext.sql.SQLOperations getDelegate() {
        return this.delegate;
    }

    SQLOperationsImpl() {
        this.delegate = null;
    }

    public SQLOperationsImpl(io.vertx.ext.sql.SQLOperations delegate) {
        this.delegate = delegate;
    }

    @Override
    @CheckReturnValue
    public Uni<ResultSet> query(String sql) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.query(sql, resultHandler));
    }

    @Override
    public ResultSet queryAndAwait(String sql) {
        return (ResultSet)this.query(sql).await().indefinitely();
    }

    @Override
    @Fluent
    public SQLOperations queryAndForget(String sql) {
        this.query(sql).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Override
    @CheckReturnValue
    public Uni<ResultSet> queryWithParams(String sql, JsonArray params) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.queryWithParams(sql, params, resultHandler));
    }

    @Override
    public ResultSet queryWithParamsAndAwait(String sql, JsonArray params) {
        return (ResultSet)this.queryWithParams(sql, params).await().indefinitely();
    }

    @Override
    @Fluent
    public SQLOperations queryWithParamsAndForget(String sql, JsonArray params) {
        this.queryWithParams(sql, params).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Override
    @CheckReturnValue
    public Uni<SQLRowStream> queryStream(String sql) {
        return AsyncResultUni.toUni(handler -> this.delegate.queryStream(sql, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> SQLRowStream.newInstance(event)))));
    }

    @Override
    public SQLRowStream queryStreamAndAwait(String sql) {
        return (SQLRowStream)this.queryStream(sql).await().indefinitely();
    }

    @Override
    @Fluent
    public SQLOperations queryStreamAndForget(String sql) {
        this.queryStream(sql).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Override
    @CheckReturnValue
    public Uni<SQLRowStream> queryStreamWithParams(String sql, JsonArray params) {
        return AsyncResultUni.toUni(handler -> this.delegate.queryStreamWithParams(sql, params, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> SQLRowStream.newInstance(event)))));
    }

    @Override
    public SQLRowStream queryStreamWithParamsAndAwait(String sql, JsonArray params) {
        return (SQLRowStream)this.queryStreamWithParams(sql, params).await().indefinitely();
    }

    @Override
    @Fluent
    public SQLOperations queryStreamWithParamsAndForget(String sql, JsonArray params) {
        this.queryStreamWithParams(sql, params).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Override
    @CheckReturnValue
    public Uni<JsonArray> querySingle(String sql) {
        return AsyncResultUni.toUni(handler -> this.delegate.querySingle(sql, handler));
    }

    @Override
    public JsonArray querySingleAndAwait(String sql) {
        return (JsonArray)this.querySingle(sql).await().indefinitely();
    }

    @Override
    @Fluent
    public SQLOperations querySingleAndForget(String sql) {
        this.querySingle(sql).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Override
    @CheckReturnValue
    public Uni<JsonArray> querySingleWithParams(String sql, JsonArray arguments) {
        return AsyncResultUni.toUni(handler -> this.delegate.querySingleWithParams(sql, arguments, handler));
    }

    @Override
    public JsonArray querySingleWithParamsAndAwait(String sql, JsonArray arguments) {
        return (JsonArray)this.querySingleWithParams(sql, arguments).await().indefinitely();
    }

    @Override
    @Fluent
    public SQLOperations querySingleWithParamsAndForget(String sql, JsonArray arguments) {
        this.querySingleWithParams(sql, arguments).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Override
    @CheckReturnValue
    public Uni<UpdateResult> update(String sql) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.update(sql, resultHandler));
    }

    @Override
    public UpdateResult updateAndAwait(String sql) {
        return (UpdateResult)this.update(sql).await().indefinitely();
    }

    @Override
    @Fluent
    public SQLOperations updateAndForget(String sql) {
        this.update(sql).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Override
    @CheckReturnValue
    public Uni<UpdateResult> updateWithParams(String sql, JsonArray params) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.updateWithParams(sql, params, resultHandler));
    }

    @Override
    public UpdateResult updateWithParamsAndAwait(String sql, JsonArray params) {
        return (UpdateResult)this.updateWithParams(sql, params).await().indefinitely();
    }

    @Override
    @Fluent
    public SQLOperations updateWithParamsAndForget(String sql, JsonArray params) {
        this.updateWithParams(sql, params).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Override
    @CheckReturnValue
    public Uni<ResultSet> call(String sql) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.call(sql, resultHandler));
    }

    @Override
    public ResultSet callAndAwait(String sql) {
        return (ResultSet)this.call(sql).await().indefinitely();
    }

    @Override
    @Fluent
    public SQLOperations callAndForget(String sql) {
        this.call(sql).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Override
    @CheckReturnValue
    public Uni<ResultSet> callWithParams(String sql, JsonArray params, JsonArray outputs) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.callWithParams(sql, params, outputs, resultHandler));
    }

    @Override
    public ResultSet callWithParamsAndAwait(String sql, JsonArray params, JsonArray outputs) {
        return (ResultSet)this.callWithParams(sql, params, outputs).await().indefinitely();
    }

    @Override
    @Fluent
    public SQLOperations callWithParamsAndForget(String sql, JsonArray params, JsonArray outputs) {
        this.callWithParams(sql, params, outputs).subscribe().with(UniHelper.NOOP);
        return this;
    }
}

