/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.cassandra;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.cassandra.CassandraClientOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.mutiny.cassandra.CassandraRowStream;
import io.vertx.mutiny.cassandra.ResultSet;
import java.util.List;

@MutinyGen(value=io.vertx.cassandra.CassandraClient.class)
public class CassandraClient {
    public static final TypeArg<CassandraClient> __TYPE_ARG = new TypeArg(obj -> new CassandraClient((io.vertx.cassandra.CassandraClient)obj), CassandraClient::getDelegate);
    private final io.vertx.cassandra.CassandraClient delegate;
    public static final String DEFAULT_SHARED_CLIENT_NAME = "DEFAULT";

    public CassandraClient(io.vertx.cassandra.CassandraClient delegate) {
        this.delegate = delegate;
    }

    CassandraClient() {
        this.delegate = null;
    }

    public io.vertx.cassandra.CassandraClient getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CassandraClient that = (CassandraClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Deprecated
    public static CassandraClient createNonShared(io.vertx.mutiny.core.Vertx vertx) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.createNonShared((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static CassandraClient create(io.vertx.mutiny.core.Vertx vertx) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    @Deprecated
    public static CassandraClient createNonShared(io.vertx.mutiny.core.Vertx vertx, CassandraClientOptions options) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.createNonShared((Vertx)vertx.getDelegate(), (CassandraClientOptions)options));
        return ret;
    }

    public static CassandraClient create(io.vertx.mutiny.core.Vertx vertx, CassandraClientOptions options) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.create((Vertx)vertx.getDelegate(), (CassandraClientOptions)options));
        return ret;
    }

    public static CassandraClient createShared(io.vertx.mutiny.core.Vertx vertx) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.createShared((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static CassandraClient createShared(io.vertx.mutiny.core.Vertx vertx, String clientName) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.createShared((Vertx)vertx.getDelegate(), (String)clientName));
        return ret;
    }

    public static CassandraClient createShared(io.vertx.mutiny.core.Vertx vertx, CassandraClientOptions options) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.createShared((Vertx)vertx.getDelegate(), (CassandraClientOptions)options));
        return ret;
    }

    public static CassandraClient createShared(io.vertx.mutiny.core.Vertx vertx, String clientName, CassandraClientOptions options) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.createShared((Vertx)vertx.getDelegate(), (String)clientName, (CassandraClientOptions)options));
        return ret;
    }

    public boolean isConnected() {
        boolean ret = this.delegate.isConnected();
        return ret;
    }

    private CassandraClient __execute(String query, final Handler<AsyncResult<ResultSet>> resultHandler) {
        this.delegate.execute(query, (Handler)new Handler<AsyncResult<io.vertx.cassandra.ResultSet>>(){

            public void handle(AsyncResult<io.vertx.cassandra.ResultSet> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)ResultSet.newInstance((io.vertx.cassandra.ResultSet)ar.result())));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<ResultSet> execute(String query) {
        return AsyncResultUni.toUni(handler -> this.__execute(query, (Handler<AsyncResult<ResultSet>>)handler));
    }

    public ResultSet executeAndAwait(String query) {
        return (ResultSet)this.execute(query).await().indefinitely();
    }

    private CassandraClient __queryStream(String sql, final Handler<AsyncResult<CassandraRowStream>> rowStreamHandler) {
        this.delegate.queryStream(sql, (Handler)new Handler<AsyncResult<io.vertx.cassandra.CassandraRowStream>>(){

            public void handle(AsyncResult<io.vertx.cassandra.CassandraRowStream> ar) {
                if (ar.succeeded()) {
                    rowStreamHandler.handle((Object)Future.succeededFuture((Object)CassandraRowStream.newInstance((io.vertx.cassandra.CassandraRowStream)ar.result())));
                } else {
                    rowStreamHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<CassandraRowStream> queryStream(String sql) {
        return AsyncResultUni.toUni(handler -> this.__queryStream(sql, (Handler<AsyncResult<CassandraRowStream>>)handler));
    }

    public CassandraRowStream queryStreamAndAwait(String sql) {
        return (CassandraRowStream)this.queryStream(sql).await().indefinitely();
    }

    private CassandraClient __close(Handler<AsyncResult<Void>> closeHandler) {
        this.delegate.close(closeHandler);
        return this;
    }

    public Uni<Void> close() {
        return AsyncResultUni.toUni(handler -> this.__close((Handler<AsyncResult<Void>>)handler));
    }

    public Void closeAndAwait() {
        return (Void)this.close().await().indefinitely();
    }

    private CassandraClient __executeWithFullFetch(String query, Handler<AsyncResult<List<Row>>> resultHandler) {
        this.delegate.executeWithFullFetch(query, resultHandler);
        return this;
    }

    public Uni<List<Row>> executeWithFullFetch(String query) {
        return AsyncResultUni.toUni(handler -> this.__executeWithFullFetch(query, (Handler<AsyncResult<List<Row>>>)handler));
    }

    public List<Row> executeWithFullFetchAndAwait(String query) {
        return (List)this.executeWithFullFetch(query).await().indefinitely();
    }

    private CassandraClient __executeWithFullFetch(Statement statement, Handler<AsyncResult<List<Row>>> resultHandler) {
        this.delegate.executeWithFullFetch(statement, resultHandler);
        return this;
    }

    public Uni<List<Row>> executeWithFullFetch(Statement statement) {
        return AsyncResultUni.toUni(handler -> this.__executeWithFullFetch(statement, (Handler<AsyncResult<List<Row>>>)handler));
    }

    public List<Row> executeWithFullFetchAndAwait(Statement statement) {
        return (List)this.executeWithFullFetch(statement).await().indefinitely();
    }

    private CassandraClient __execute(Statement statement, final Handler<AsyncResult<ResultSet>> resultHandler) {
        this.delegate.execute(statement, (Handler)new Handler<AsyncResult<io.vertx.cassandra.ResultSet>>(){

            public void handle(AsyncResult<io.vertx.cassandra.ResultSet> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)ResultSet.newInstance((io.vertx.cassandra.ResultSet)ar.result())));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<ResultSet> execute(Statement statement) {
        return AsyncResultUni.toUni(handler -> this.__execute(statement, (Handler<AsyncResult<ResultSet>>)handler));
    }

    public ResultSet executeAndAwait(Statement statement) {
        return (ResultSet)this.execute(statement).await().indefinitely();
    }

    private CassandraClient __prepare(String query, Handler<AsyncResult<PreparedStatement>> resultHandler) {
        this.delegate.prepare(query, resultHandler);
        return this;
    }

    public Uni<PreparedStatement> prepare(String query) {
        return AsyncResultUni.toUni(handler -> this.__prepare(query, (Handler<AsyncResult<PreparedStatement>>)handler));
    }

    public PreparedStatement prepareAndAwait(String query) {
        return (PreparedStatement)this.prepare(query).await().indefinitely();
    }

    private CassandraClient __queryStream(Statement statement, final Handler<AsyncResult<CassandraRowStream>> rowStreamHandler) {
        this.delegate.queryStream(statement, (Handler)new Handler<AsyncResult<io.vertx.cassandra.CassandraRowStream>>(){

            public void handle(AsyncResult<io.vertx.cassandra.CassandraRowStream> ar) {
                if (ar.succeeded()) {
                    rowStreamHandler.handle((Object)Future.succeededFuture((Object)CassandraRowStream.newInstance((io.vertx.cassandra.CassandraRowStream)ar.result())));
                } else {
                    rowStreamHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<CassandraRowStream> queryStream(Statement statement) {
        return AsyncResultUni.toUni(handler -> this.__queryStream(statement, (Handler<AsyncResult<CassandraRowStream>>)handler));
    }

    public CassandraRowStream queryStreamAndAwait(Statement statement) {
        return (CassandraRowStream)this.queryStream(statement).await().indefinitely();
    }

    public CassandraClient closeAndForget() {
        this.delegate.close();
        return this;
    }

    public static CassandraClient newInstance(io.vertx.cassandra.CassandraClient arg) {
        return arg != null ? new CassandraClient(arg) : null;
    }
}

