/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.ext.auth.sqlclient;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.sqlclient.SqlClient;

@MutinyGen(value=io.vertx.ext.auth.sqlclient.SqlUserUtil.class)
public class SqlUserUtil {
    public static final TypeArg<SqlUserUtil> __TYPE_ARG = new TypeArg(obj -> new SqlUserUtil((io.vertx.ext.auth.sqlclient.SqlUserUtil)obj), SqlUserUtil::getDelegate);
    private final io.vertx.ext.auth.sqlclient.SqlUserUtil delegate;

    public SqlUserUtil(io.vertx.ext.auth.sqlclient.SqlUserUtil delegate) {
        this.delegate = delegate;
    }

    public SqlUserUtil(Object delegate) {
        this.delegate = (io.vertx.ext.auth.sqlclient.SqlUserUtil)delegate;
    }

    SqlUserUtil() {
        this.delegate = null;
    }

    public io.vertx.ext.auth.sqlclient.SqlUserUtil getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlUserUtil that = (SqlUserUtil)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static SqlUserUtil create(io.vertx.mutiny.sqlclient.SqlClient client) {
        SqlUserUtil ret = SqlUserUtil.newInstance(io.vertx.ext.auth.sqlclient.SqlUserUtil.create((SqlClient)client.getDelegate()));
        return ret;
    }

    public static SqlUserUtil create(io.vertx.mutiny.sqlclient.SqlClient client, String insertUserSQL, String insertUserRoleSQL, String insertRolePermissionSQL) {
        SqlUserUtil ret = SqlUserUtil.newInstance(io.vertx.ext.auth.sqlclient.SqlUserUtil.create((SqlClient)client.getDelegate(), (String)insertUserSQL, (String)insertUserRoleSQL, (String)insertRolePermissionSQL));
        return ret;
    }

    public Uni<Void> createUser(String username, String password) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.createUser(username, password, resultHandler));
    }

    public Void createUserAndAwait(String username, String password) {
        return (Void)this.createUser(username, password).await().indefinitely();
    }

    @Fluent
    public SqlUserUtil createUserAndForget(String username, String password) {
        this.createUser(username, password).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public Uni<Void> createHashedUser(String username, String hash) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.createHashedUser(username, hash, resultHandler));
    }

    public Void createHashedUserAndAwait(String username, String hash) {
        return (Void)this.createHashedUser(username, hash).await().indefinitely();
    }

    @Fluent
    public SqlUserUtil createHashedUserAndForget(String username, String hash) {
        this.createHashedUser(username, hash).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public Uni<Void> createUserRole(String username, String role) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.createUserRole(username, role, resultHandler));
    }

    public Void createUserRoleAndAwait(String username, String role) {
        return (Void)this.createUserRole(username, role).await().indefinitely();
    }

    @Fluent
    public SqlUserUtil createUserRoleAndForget(String username, String role) {
        this.createUserRole(username, role).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public Uni<Void> createRolePermission(String role, String permission) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.createRolePermission(role, permission, resultHandler));
    }

    public Void createRolePermissionAndAwait(String role, String permission) {
        return (Void)this.createRolePermission(role, permission).await().indefinitely();
    }

    @Fluent
    public SqlUserUtil createRolePermissionAndForget(String role, String permission) {
        this.createRolePermission(role, permission).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public static SqlUserUtil newInstance(io.vertx.ext.auth.sqlclient.SqlUserUtil arg) {
        return arg != null ? new SqlUserUtil(arg) : null;
    }
}

