/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.ext.auth.otp.hotp;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Future;
import io.vertx.ext.auth.otp.Authenticator;
import io.vertx.ext.auth.otp.OtpKey;
import io.vertx.ext.auth.otp.hotp.HotpAuthOptions;
import io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider;
import java.util.function.Function;

@MutinyGen(value=io.vertx.ext.auth.otp.hotp.HotpAuth.class)
public class HotpAuth
extends AuthenticationProvider {
    public static final TypeArg<HotpAuth> __TYPE_ARG = new TypeArg(obj -> new HotpAuth((io.vertx.ext.auth.otp.hotp.HotpAuth)obj), HotpAuth::getDelegate);
    private final io.vertx.ext.auth.otp.hotp.HotpAuth delegate;

    public HotpAuth(io.vertx.ext.auth.otp.hotp.HotpAuth delegate) {
        super((io.vertx.ext.auth.authentication.AuthenticationProvider)delegate);
        this.delegate = delegate;
    }

    public HotpAuth(Object delegate) {
        super((io.vertx.ext.auth.authentication.AuthenticationProvider)((io.vertx.ext.auth.otp.hotp.HotpAuth)delegate));
        this.delegate = (io.vertx.ext.auth.otp.hotp.HotpAuth)delegate;
    }

    HotpAuth() {
        super(null);
        this.delegate = null;
    }

    public io.vertx.ext.auth.otp.hotp.HotpAuth getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        HotpAuth that = (HotpAuth)((Object)o);
        return this.delegate.equals((Object)that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Fluent
    public HotpAuth authenticatorFetcher(final Function<String, Uni<Authenticator>> fetcher) {
        this.delegate.authenticatorFetcher((Function)new Function<String, Future<Authenticator>>(){

            @Override
            public Future<Authenticator> apply(String arg) {
                return UniHelper.toFuture((Uni)((Uni)fetcher.apply(arg)));
            }
        });
        return this;
    }

    @Fluent
    public HotpAuth authenticatorUpdater(final Function<Authenticator, Uni<Void>> updater) {
        this.delegate.authenticatorUpdater((Function)new Function<Authenticator, Future<Void>>(){

            @Override
            public Future<Void> apply(Authenticator arg) {
                return UniHelper.toFuture((Uni)((Uni)updater.apply(arg)));
            }
        });
        return this;
    }

    @CheckReturnValue
    public Uni<Authenticator> createAuthenticator(String id, OtpKey otpKey) {
        return UniHelper.toUni((Future)this.delegate.createAuthenticator(id, otpKey));
    }

    public Authenticator createAuthenticatorAndAwait(String id, OtpKey otpKey) {
        return (Authenticator)this.createAuthenticator(id, otpKey).await().indefinitely();
    }

    public void createAuthenticatorAndForget(String id, OtpKey otpKey) {
        this.createAuthenticator(id, otpKey).subscribe().with(UniHelper.NOOP);
    }

    public String generateUri(OtpKey otpKey, String issuer, String user, String label) {
        String ret = this.delegate.generateUri(otpKey, issuer, user, label);
        return ret;
    }

    public String generateUri(OtpKey otpKey, String issuer, String user) {
        String ret = this.delegate.generateUri(otpKey, issuer, user);
        return ret;
    }

    public String generateUri(OtpKey otpKey, String label) {
        String ret = this.delegate.generateUri(otpKey, label);
        return ret;
    }

    public static HotpAuth create() {
        HotpAuth ret = HotpAuth.newInstance(io.vertx.ext.auth.otp.hotp.HotpAuth.create());
        return ret;
    }

    public static HotpAuth create(HotpAuthOptions hotpAuthOptions) {
        HotpAuth ret = HotpAuth.newInstance(io.vertx.ext.auth.otp.hotp.HotpAuth.create((HotpAuthOptions)hotpAuthOptions));
        return ret;
    }

    public static HotpAuth newInstance(io.vertx.ext.auth.otp.hotp.HotpAuth arg) {
        return arg != null ? new HotpAuth(arg) : null;
    }
}

