/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.ext.auth.otp.totp;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Future;
import io.vertx.ext.auth.otp.Authenticator;
import io.vertx.ext.auth.otp.OtpKey;
import io.vertx.ext.auth.otp.totp.TotpAuthOptions;
import io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider;
import java.util.function.Function;

@MutinyGen(value=io.vertx.ext.auth.otp.totp.TotpAuth.class)
public class TotpAuth
extends AuthenticationProvider {
    public static final TypeArg<TotpAuth> __TYPE_ARG = new TypeArg(obj -> new TotpAuth((io.vertx.ext.auth.otp.totp.TotpAuth)obj), TotpAuth::getDelegate);
    private final io.vertx.ext.auth.otp.totp.TotpAuth delegate;

    public TotpAuth(io.vertx.ext.auth.otp.totp.TotpAuth delegate) {
        super((io.vertx.ext.auth.authentication.AuthenticationProvider)delegate);
        this.delegate = delegate;
    }

    public TotpAuth(Object delegate) {
        super((io.vertx.ext.auth.authentication.AuthenticationProvider)((io.vertx.ext.auth.otp.totp.TotpAuth)delegate));
        this.delegate = (io.vertx.ext.auth.otp.totp.TotpAuth)delegate;
    }

    TotpAuth() {
        super(null);
        this.delegate = null;
    }

    public io.vertx.ext.auth.otp.totp.TotpAuth getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        TotpAuth that = (TotpAuth)((Object)o);
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Fluent
    public TotpAuth authenticatorFetcher(final Function<String, Uni<Authenticator>> fetcher) {
        this.delegate.authenticatorFetcher((Function)new Function<String, Future<Authenticator>>(){

            @Override
            public Future<Authenticator> apply(String arg) {
                return UniHelper.toFuture((Uni)((Uni)fetcher.apply(arg)));
            }
        });
        return this;
    }

    @Fluent
    public TotpAuth authenticatorUpdater(final Function<Authenticator, Uni<Void>> updater) {
        this.delegate.authenticatorUpdater((Function)new Function<Authenticator, Future<Void>>(){

            @Override
            public Future<Void> apply(Authenticator arg) {
                return UniHelper.toFuture((Uni)((Uni)updater.apply(arg)));
            }
        });
        return this;
    }

    @CheckReturnValue
    public Uni<Authenticator> createAuthenticator(String id, OtpKey otpKey) {
        return UniHelper.toUni((Future)this.delegate.createAuthenticator(id, otpKey));
    }

    public Authenticator createAuthenticatorAndAwait(String id, OtpKey otpKey) {
        return (Authenticator)this.createAuthenticator(id, otpKey).await().indefinitely();
    }

    public void createAuthenticatorAndForget(String id, OtpKey otpKey) {
        this.createAuthenticator(id, otpKey).subscribe().with(UniHelper.NOOP);
    }

    public String generateUri(OtpKey otpKey, String issuer, String user, String label) {
        String ret = this.delegate.generateUri(otpKey, issuer, user, label);
        return ret;
    }

    public String generateUri(OtpKey otpKey, String issuer, String user) {
        String ret = this.delegate.generateUri(otpKey, issuer, user);
        return ret;
    }

    public String generateUri(OtpKey otpKey, String label) {
        String ret = this.delegate.generateUri(otpKey, label);
        return ret;
    }

    public static TotpAuth create() {
        TotpAuth ret = TotpAuth.newInstance(io.vertx.ext.auth.otp.totp.TotpAuth.create());
        return ret;
    }

    public static TotpAuth create(TotpAuthOptions totpAuthOptions) {
        TotpAuth ret = TotpAuth.newInstance(io.vertx.ext.auth.otp.totp.TotpAuth.create((TotpAuthOptions)totpAuthOptions));
        return ret;
    }

    public static TotpAuth newInstance(io.vertx.ext.auth.otp.totp.TotpAuth arg) {
        return arg != null ? new TotpAuth(arg) : null;
    }
}

