/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.ext.auth.oauth2.providers;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.ext.auth.oauth2.OAuth2Options;
import io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth;
import io.vertx.mutiny.ext.auth.oauth2.providers.OpenIDConnectAuth;

@MutinyGen(value=io.vertx.ext.auth.oauth2.providers.AmazonCognitoAuth.class)
public class AmazonCognitoAuth
extends OpenIDConnectAuth {
    public static final TypeArg<AmazonCognitoAuth> __TYPE_ARG = new TypeArg(obj -> new AmazonCognitoAuth((io.vertx.ext.auth.oauth2.providers.AmazonCognitoAuth)obj), AmazonCognitoAuth::getDelegate);
    private final io.vertx.ext.auth.oauth2.providers.AmazonCognitoAuth delegate;

    public AmazonCognitoAuth(io.vertx.ext.auth.oauth2.providers.AmazonCognitoAuth delegate) {
        super((io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth)delegate);
        this.delegate = delegate;
    }

    public AmazonCognitoAuth(Object delegate) {
        super((io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth)((io.vertx.ext.auth.oauth2.providers.AmazonCognitoAuth)delegate));
        this.delegate = (io.vertx.ext.auth.oauth2.providers.AmazonCognitoAuth)delegate;
    }

    AmazonCognitoAuth() {
        super(null);
        this.delegate = null;
    }

    public io.vertx.ext.auth.oauth2.providers.AmazonCognitoAuth getDelegate() {
        return this.delegate;
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AmazonCognitoAuth that = (AmazonCognitoAuth)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static OAuth2Auth create(io.vertx.mutiny.core.Vertx vertx, String region, String clientId, String clientSecret, String guid) {
        OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.providers.AmazonCognitoAuth.create((Vertx)vertx.getDelegate(), (String)region, (String)clientId, (String)clientSecret, (String)guid));
        return ret;
    }

    public static OAuth2Auth create(io.vertx.mutiny.core.Vertx vertx, String region, String clientId, String clientSecret, String userPoolId, HttpClientOptions httpClientOptions) {
        OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.providers.AmazonCognitoAuth.create((Vertx)vertx.getDelegate(), (String)region, (String)clientId, (String)clientSecret, (String)userPoolId, (HttpClientOptions)httpClientOptions));
        return ret;
    }

    @CheckReturnValue
    public static Uni<OAuth2Auth> discover(io.vertx.mutiny.core.Vertx vertx, OAuth2Options config) {
        return AsyncResultUni.toUni(handler -> io.vertx.ext.auth.oauth2.providers.AmazonCognitoAuth.discover((Vertx)vertx.getDelegate(), (OAuth2Options)config, (Handler)new Handler<AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Auth>>(){

            public void handle(AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Auth> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)((Object)OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)ar.result()))));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public static OAuth2Auth discoverAndAwait(io.vertx.mutiny.core.Vertx vertx, OAuth2Options config) {
        return (OAuth2Auth)((Object)AmazonCognitoAuth.discover(vertx, config).await().indefinitely());
    }

    public static void discoverAndForget(io.vertx.mutiny.core.Vertx vertx, OAuth2Options config) {
        AmazonCognitoAuth.discover(vertx, config).subscribe().with(UniHelper.NOOP);
    }

    public static AmazonCognitoAuth newInstance(io.vertx.ext.auth.oauth2.providers.AmazonCognitoAuth arg) {
        return arg != null ? new AmazonCognitoAuth(arg) : null;
    }
}

