/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.ext.auth.oauth2;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.ext.auth.User;
import io.vertx.mutiny.ext.auth.oauth2.OAuth2Response;

@MutinyGen(value=io.vertx.ext.auth.oauth2.AccessToken.class)
public class AccessToken
extends User {
    public static final TypeArg<AccessToken> __TYPE_ARG = new TypeArg(obj -> new AccessToken((io.vertx.ext.auth.oauth2.AccessToken)obj), AccessToken::getDelegate);
    private final io.vertx.ext.auth.oauth2.AccessToken delegate;
    private JsonObject cached_0;
    private JsonObject cached_1;
    private JsonObject cached_2;

    public AccessToken(io.vertx.ext.auth.oauth2.AccessToken delegate) {
        super((io.vertx.ext.auth.User)delegate);
        this.delegate = delegate;
    }

    AccessToken() {
        super(null);
        this.delegate = null;
    }

    public io.vertx.ext.auth.oauth2.AccessToken getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AccessToken that = (AccessToken)((Object)o);
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean expired() {
        boolean ret = this.delegate.expired();
        return ret;
    }

    public JsonObject accessToken() {
        JsonObject ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = this.delegate.accessToken();
        return ret;
    }

    @Deprecated
    public JsonObject refreshToken() {
        JsonObject ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = this.delegate.refreshToken();
        return ret;
    }

    public JsonObject idToken() {
        JsonObject ret;
        if (this.cached_2 != null) {
            return this.cached_2;
        }
        this.cached_2 = ret = this.delegate.idToken();
        return ret;
    }

    public String opaqueAccessToken() {
        String ret = this.delegate.opaqueAccessToken();
        return ret;
    }

    public String opaqueRefreshToken() {
        String ret = this.delegate.opaqueRefreshToken();
        return ret;
    }

    public String opaqueIdToken() {
        String ret = this.delegate.opaqueIdToken();
        return ret;
    }

    public String tokenType() {
        String ret = this.delegate.tokenType();
        return ret;
    }

    public AccessToken setTrustJWT(boolean trust) {
        this.delegate.setTrustJWT(trust);
        return this;
    }

    private AccessToken __refresh(Handler<AsyncResult<Void>> callback) {
        this.delegate.refresh(callback);
        return this;
    }

    public Uni<Void> refresh() {
        return AsyncResultUni.toUni(handler -> this.__refresh((Handler<AsyncResult<Void>>)handler));
    }

    public Void refreshAndAwait() {
        return (Void)this.refresh().await().indefinitely();
    }

    private AccessToken __revoke(String token_type, Handler<AsyncResult<Void>> callback) {
        this.delegate.revoke(token_type, callback);
        return this;
    }

    public Uni<Void> revoke(String token_type) {
        return AsyncResultUni.toUni(handler -> this.__revoke(token_type, (Handler<AsyncResult<Void>>)handler));
    }

    public Void revokeAndAwait(String token_type) {
        return (Void)this.revoke(token_type).await().indefinitely();
    }

    private AccessToken __logout(Handler<AsyncResult<Void>> callback) {
        this.delegate.logout(callback);
        return this;
    }

    public Uni<Void> logout() {
        return AsyncResultUni.toUni(handler -> this.__logout((Handler<AsyncResult<Void>>)handler));
    }

    public Void logoutAndAwait() {
        return (Void)this.logout().await().indefinitely();
    }

    private AccessToken __introspect(Handler<AsyncResult<Void>> callback) {
        this.delegate.introspect(callback);
        return this;
    }

    public Uni<Void> introspect() {
        return AsyncResultUni.toUni(handler -> this.__introspect((Handler<AsyncResult<Void>>)handler));
    }

    public Void introspectAndAwait() {
        return (Void)this.introspect().await().indefinitely();
    }

    private AccessToken __introspect(String tokenType, Handler<AsyncResult<Void>> callback) {
        this.delegate.introspect(tokenType, callback);
        return this;
    }

    public Uni<Void> introspect(String tokenType) {
        return AsyncResultUni.toUni(handler -> this.__introspect(tokenType, (Handler<AsyncResult<Void>>)handler));
    }

    public Void introspectAndAwait(String tokenType) {
        return (Void)this.introspect(tokenType).await().indefinitely();
    }

    private AccessToken __userInfo(Handler<AsyncResult<JsonObject>> callback) {
        this.delegate.userInfo(callback);
        return this;
    }

    public Uni<JsonObject> userInfo() {
        return AsyncResultUni.toUni(handler -> this.__userInfo((Handler<AsyncResult<JsonObject>>)handler));
    }

    public JsonObject userInfoAndAwait() {
        return (JsonObject)this.userInfo().await().indefinitely();
    }

    private AccessToken __fetch(String resource, final Handler<AsyncResult<OAuth2Response>> callback) {
        this.delegate.fetch(resource, (Handler)new Handler<AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Response>>(){

            public void handle(AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Response> ar) {
                if (ar.succeeded()) {
                    callback.handle((Object)Future.succeededFuture((Object)OAuth2Response.newInstance((io.vertx.ext.auth.oauth2.OAuth2Response)ar.result())));
                } else {
                    callback.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<OAuth2Response> fetch(String resource) {
        return AsyncResultUni.toUni(handler -> this.__fetch(resource, (Handler<AsyncResult<OAuth2Response>>)handler));
    }

    public OAuth2Response fetchAndAwait(String resource) {
        return (OAuth2Response)this.fetch(resource).await().indefinitely();
    }

    private AccessToken __fetch(HttpMethod method, String resource, JsonObject headers, Buffer payload, final Handler<AsyncResult<OAuth2Response>> callback) {
        this.delegate.fetch(method, resource, headers, payload.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Response>>(){

            public void handle(AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Response> ar) {
                if (ar.succeeded()) {
                    callback.handle((Object)Future.succeededFuture((Object)OAuth2Response.newInstance((io.vertx.ext.auth.oauth2.OAuth2Response)ar.result())));
                } else {
                    callback.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<OAuth2Response> fetch(HttpMethod method, String resource, JsonObject headers, Buffer payload) {
        return AsyncResultUni.toUni(handler -> this.__fetch(method, resource, headers, payload, (Handler<AsyncResult<OAuth2Response>>)handler));
    }

    public OAuth2Response fetchAndAwait(HttpMethod method, String resource, JsonObject headers, Buffer payload) {
        return (OAuth2Response)this.fetch(method, resource, headers, payload).await().indefinitely();
    }

    public static AccessToken newInstance(io.vertx.ext.auth.oauth2.AccessToken arg) {
        return arg != null ? new AccessToken(arg) : null;
    }
}

