package io.vertx.mutiny.ext.auth.authentication;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;
import io.vertx.ext.auth.authentication.Credentials;

/**
 *
 * User-facing interface for authenticating users.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.authentication.AuthenticationProvider original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.auth.authentication.AuthenticationProvider.class)
public class AuthenticationProvider {

  public static final io.smallrye.mutiny.vertx.TypeArg<AuthenticationProvider> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new AuthenticationProvider((io.vertx.ext.auth.authentication.AuthenticationProvider) obj),
    AuthenticationProvider::getDelegate
  );

  private final io.vertx.ext.auth.authentication.AuthenticationProvider delegate;
  
  public AuthenticationProvider(io.vertx.ext.auth.authentication.AuthenticationProvider delegate) {
    this.delegate = delegate;
  }

  public AuthenticationProvider(Object delegate) {
    this.delegate = (io.vertx.ext.auth.authentication.AuthenticationProvider)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  AuthenticationProvider() {
    this.delegate = null;
  }

  public io.vertx.ext.auth.authentication.AuthenticationProvider getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AuthenticationProvider that = (AuthenticationProvider) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * Authenticate a user.
   * <p>
   * The first argument is a JSON object containing information for authenticating the user. What this actually contains
   * depends on the specific implementation. In the case of a simple username/password based
   * authentication it is likely to contain a JSON object with the following structure:
   * <pre>
   *   {
   *     "username": "tim",
   *     "password": "mypassword"
   *   }
   * </pre>
   * For other types of authentication it contain different information - for example a JWT token or OAuth bearer token.
   * <p>
   * If the user is successfully authenticated a  object is passed to the handler in an .
   * The user object can then be used for authorisation.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param credentials The credentials
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   * @deprecated For type safety this method should be avoided and {@link #authenticate(Credentials, Handler)} should be used instead.   */
  @CheckReturnValue
  @Deprecated
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.auth.User> authenticate(JsonObject credentials) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.authenticate(credentials, new io.smallrye.mutiny.vertx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.ext.auth.User.newInstance((io.vertx.ext.auth.User)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider#authenticate(JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param credentials The credentials
   * @return the User instance produced by the operation.
   * @deprecated For type safety this method should be avoided and {@link #authenticate(Credentials, Handler)} should be used instead.   */
  @Deprecated
  public io.vertx.mutiny.ext.auth.User authenticateAndAwait(JsonObject credentials) { 
    return (io.vertx.mutiny.ext.auth.User) authenticate(credentials).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider#authenticate(JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider#authenticate(JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider#authenticate(JsonObject)} but you don't need to compose it with other operations.
   * @param credentials The credentials
   * @deprecated For type safety this method should be avoided and {@link #authenticate(Credentials, Handler)} should be used instead.   */
  @Deprecated
  public void authenticateAndForget(JsonObject credentials) { 
    authenticate(credentials).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Authenticate a user.
   * <p>
   * The first argument is a Credentials object containing information for authenticating the user.
   * What this actually contains depends on the specific implementation.
   *
   * If the user is successfully authenticated a  object is passed to the handler in an .
   * The user object can then be used for authorisation.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param credentials The credentials
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.auth.User> authenticate(io.vertx.ext.auth.authentication.Credentials credentials) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.authenticate(credentials, new io.smallrye.mutiny.vertx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.ext.auth.User.newInstance((io.vertx.ext.auth.User)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider#authenticate(Credentials)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param credentials The credentials
   * @return the User instance produced by the operation.
   */
  public io.vertx.mutiny.ext.auth.User authenticateAndAwait(io.vertx.ext.auth.authentication.Credentials credentials) { 
    return (io.vertx.mutiny.ext.auth.User) authenticate(credentials).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider#authenticate(Credentials)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider#authenticate(Credentials)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider#authenticate(Credentials)} but you don't need to compose it with other operations.
   * @param credentials The credentials
   */
  public void authenticateAndForget(io.vertx.ext.auth.authentication.Credentials credentials) { 
    authenticate(credentials).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  public static  AuthenticationProvider newInstance(io.vertx.ext.auth.authentication.AuthenticationProvider arg) {
    return arg != null ? new AuthenticationProvider(arg) : null;
  }

}
