/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.amqp;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.amqp.AmqpClientOptions;
import io.vertx.amqp.AmqpReceiverOptions;
import io.vertx.amqp.AmqpSenderOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.mutiny.amqp.AmqpConnection;
import io.vertx.mutiny.amqp.AmqpReceiver;
import io.vertx.mutiny.amqp.AmqpSender;

@MutinyGen(value=io.vertx.amqp.AmqpClient.class)
public class AmqpClient {
    public static final TypeArg<AmqpClient> __TYPE_ARG = new TypeArg(obj -> new AmqpClient((io.vertx.amqp.AmqpClient)obj), AmqpClient::getDelegate);
    private final io.vertx.amqp.AmqpClient delegate;

    public AmqpClient(io.vertx.amqp.AmqpClient delegate) {
        this.delegate = delegate;
    }

    AmqpClient() {
        this.delegate = null;
    }

    public io.vertx.amqp.AmqpClient getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AmqpClient that = (AmqpClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static AmqpClient create(AmqpClientOptions options) {
        AmqpClient ret = AmqpClient.newInstance(io.vertx.amqp.AmqpClient.create((AmqpClientOptions)options));
        return ret;
    }

    public static AmqpClient create(io.vertx.mutiny.core.Vertx vertx, AmqpClientOptions options) {
        AmqpClient ret = AmqpClient.newInstance(io.vertx.amqp.AmqpClient.create((Vertx)vertx.getDelegate(), (AmqpClientOptions)options));
        return ret;
    }

    private AmqpClient __connect(final Handler<AsyncResult<AmqpConnection>> connectionHandler) {
        this.delegate.connect((Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpConnection>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpConnection> ar) {
                if (ar.succeeded()) {
                    connectionHandler.handle((Object)Future.succeededFuture((Object)AmqpConnection.newInstance((io.vertx.amqp.AmqpConnection)ar.result())));
                } else {
                    connectionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<AmqpConnection> connect() {
        return AsyncResultUni.toUni(handler -> this.__connect((Handler<AsyncResult<AmqpConnection>>)handler));
    }

    public AmqpConnection connectAndAwait() {
        return (AmqpConnection)this.connect().await().indefinitely();
    }

    private void __close(Handler<AsyncResult<Void>> closeHandler) {
        this.delegate.close(closeHandler);
    }

    public Uni<Void> close() {
        return AsyncResultUni.toUni(handler -> this.__close((Handler<AsyncResult<Void>>)handler));
    }

    public Void closeAndAwait() {
        return (Void)this.close().await().indefinitely();
    }

    private AmqpClient __createReceiver(String address, final Handler<AsyncResult<AmqpReceiver>> completionHandler) {
        this.delegate.createReceiver(address, (Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpReceiver>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpReceiver> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture((Object)AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)ar.result())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<AmqpReceiver> createReceiver(String address) {
        return AsyncResultUni.toUni(handler -> this.__createReceiver(address, (Handler<AsyncResult<AmqpReceiver>>)handler));
    }

    public AmqpReceiver createReceiverAndAwait(String address) {
        return (AmqpReceiver)this.createReceiver(address).await().indefinitely();
    }

    private AmqpClient __createReceiver(String address, AmqpReceiverOptions receiverOptions, final Handler<AsyncResult<AmqpReceiver>> completionHandler) {
        this.delegate.createReceiver(address, receiverOptions, (Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpReceiver>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpReceiver> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture((Object)AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)ar.result())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<AmqpReceiver> createReceiver(String address, AmqpReceiverOptions receiverOptions) {
        return AsyncResultUni.toUni(handler -> this.__createReceiver(address, receiverOptions, (Handler<AsyncResult<AmqpReceiver>>)handler));
    }

    public AmqpReceiver createReceiverAndAwait(String address, AmqpReceiverOptions receiverOptions) {
        return (AmqpReceiver)this.createReceiver(address, receiverOptions).await().indefinitely();
    }

    private AmqpClient __createSender(String address, final Handler<AsyncResult<AmqpSender>> completionHandler) {
        this.delegate.createSender(address, (Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpSender>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpSender> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture((Object)AmqpSender.newInstance((io.vertx.amqp.AmqpSender)ar.result())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<AmqpSender> createSender(String address) {
        return AsyncResultUni.toUni(handler -> this.__createSender(address, (Handler<AsyncResult<AmqpSender>>)handler));
    }

    public AmqpSender createSenderAndAwait(String address) {
        return (AmqpSender)this.createSender(address).await().indefinitely();
    }

    private AmqpClient __createSender(String address, AmqpSenderOptions options, final Handler<AsyncResult<AmqpSender>> completionHandler) {
        this.delegate.createSender(address, options, (Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpSender>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpSender> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture((Object)AmqpSender.newInstance((io.vertx.amqp.AmqpSender)ar.result())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<AmqpSender> createSender(String address, AmqpSenderOptions options) {
        return AsyncResultUni.toUni(handler -> this.__createSender(address, options, (Handler<AsyncResult<AmqpSender>>)handler));
    }

    public AmqpSender createSenderAndAwait(String address, AmqpSenderOptions options) {
        return (AmqpSender)this.createSender(address, options).await().indefinitely();
    }

    public static AmqpClient newInstance(io.vertx.amqp.AmqpClient arg) {
        return arg != null ? new AmqpClient(arg) : null;
    }
}

