/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.uni.UniAndCombination;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class UniAndGroupIterable<T1> {
    private final Uni<? extends T1> source;
    private final List<? extends Uni<?>> unis;
    private boolean collectFailures;
    private int concurrency = -1;

    public UniAndGroupIterable(Iterable<? extends Uni<?>> iterable) {
        this(null, iterable, false);
    }

    public UniAndGroupIterable(Uni<? extends T1> source, Iterable<? extends Uni<?>> iterable) {
        this(source, iterable, false);
    }

    public UniAndGroupIterable(Uni<? extends T1> source, Iterable<? extends Uni<?>> iterable, boolean collectFailures) {
        this.source = source;
        List others = iterable instanceof List ? (List)iterable : StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList());
        this.unis = others;
        this.collectFailures = collectFailures;
    }

    @CheckReturnValue
    public UniAndGroupIterable<T1> collectFailures() {
        this.collectFailures = true;
        return this;
    }

    @CheckReturnValue
    public UniAndGroupIterable<T1> usingConcurrencyOf(int level) {
        this.concurrency = ParameterValidation.positive(level, "level");
        return this;
    }

    @Deprecated
    @CheckReturnValue
    public <O> Uni<O> combinedWith(Function<List<?>, O> function) {
        return this.with(function);
    }

    @CheckReturnValue
    public <O> Uni<O> with(Function<List<?>, O> function) {
        Function<List<?>, O> actual = Infrastructure.decorate(ParameterValidation.nonNull(function, "function"));
        return Infrastructure.onUniCreation(new UniAndCombination<T1, O>(this.source, this.unis, actual, this.collectFailures, this.concurrency));
    }

    @CheckReturnValue
    public <O> Uni<O> withUni(Function<List<?>, Uni<O>> function) {
        Function<List<?>, Uni<O>> actual = Infrastructure.decorate(ParameterValidation.nonNull(function, "function"));
        return Infrastructure.onUniCreation(new UniAndCombination<T1, Uni<O>>(this.source, this.unis, actual, this.collectFailures, this.concurrency)).flatMap(Function.identity());
    }

    @Deprecated
    @CheckReturnValue
    public <O, I> Uni<O> combinedWith(Class<I> superType, Function<List<I>, O> function) {
        return this.with(superType, function);
    }

    @CheckReturnValue
    public <O, I> Uni<O> with(Class<I> superType, Function<List<I>, O> function) {
        return this.with(function);
    }

    @CheckReturnValue
    public <O, I> Uni<O> withUni(Class<I> superType, Function<List<I>, Uni<O>> function) {
        return this.withUni(function);
    }

    @CheckReturnValue
    public Uni<Void> discardItems() {
        return Infrastructure.onUniCreation(new UniAndCombination<T1, Void>(this.source, this.unis, x -> null, this.collectFailures, this.concurrency));
    }
}

