/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.queues.Queues;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.MultiFlatMapOp;
import java.util.concurrent.Flow;
import java.util.function.Function;

public class MultiFlatten<I, O> {
    private final Function<? super I, ? extends Flow.Publisher<? extends O>> mapper;
    private final Multi<I> upstream;
    private final int requests;
    private final boolean collectFailureUntilCompletion;

    MultiFlatten(Multi<I> upstream, Function<? super I, ? extends Flow.Publisher<? extends O>> mapper, int requests, boolean collectFailures) {
        this.upstream = upstream;
        this.mapper = mapper;
        this.requests = requests;
        this.collectFailureUntilCompletion = collectFailures;
    }

    @CheckReturnValue
    public MultiFlatten<I, O> collectFailures() {
        return new MultiFlatten<I, O>(this.upstream, this.mapper, this.requests, true);
    }

    @CheckReturnValue
    public MultiFlatten<I, O> withRequests(int requests) {
        return new MultiFlatten<I, O>(this.upstream, this.mapper, ParameterValidation.positive(requests, "requests"), this.collectFailureUntilCompletion);
    }

    @CheckReturnValue
    public Multi<O> merge() {
        return this.merge(Queues.BUFFER_S);
    }

    @CheckReturnValue
    public Multi<O> merge(int concurrency) {
        return Infrastructure.onMultiCreation(new MultiFlatMapOp(this.upstream, this.mapper, this.collectFailureUntilCompletion, concurrency, this.requests));
    }

    @CheckReturnValue
    public Multi<O> concatenate() {
        return Infrastructure.onMultiCreation(new MultiFlatMapOp(this.upstream, this.mapper, this.collectFailureUntilCompletion, 1, this.requests));
    }
}

