/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Context;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.subscription.ContextSupport;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import io.smallrye.mutiny.subscription.SwitchableSubscriptionSubscriber;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;

public class MultiConcatMapOp<I, O>
extends AbstractMultiOperator<I, O> {
    private final Function<? super I, ? extends Publisher<? extends O>> mapper;
    private final boolean postponeFailurePropagation;

    public MultiConcatMapOp(Multi<? extends I> upstream, Function<? super I, ? extends Publisher<? extends O>> mapper, boolean postponeFailurePropagation) {
        super(upstream);
        this.mapper = mapper;
        this.postponeFailurePropagation = postponeFailurePropagation;
    }

    @Override
    public void subscribe(MultiSubscriber<? super O> subscriber) {
        if (subscriber == null) {
            throw new NullPointerException("The subscriber must not be `null`");
        }
        ConcatMapMainSubscriber<? super I, ? super O> sub = new ConcatMapMainSubscriber<I, O>(subscriber, this.mapper, this.postponeFailurePropagation);
        this.upstream.subscribe(Infrastructure.onMultiSubscription(this.upstream, sub));
    }

    public static final class ConcatMapMainSubscriber<I, O>
    implements MultiSubscriber<I>,
    Subscription,
    ContextSupport {
        private static final int STATE_NEW = 0;
        private static final int STATE_READY = 1;
        private static final int STATE_EMITTING = 2;
        private static final int STATE_OUTER_TERMINATED = 3;
        private static final int STATE_TERMINATED = 4;
        private static final int STATE_CANCELLED = 5;
        final AtomicInteger state = new AtomicInteger(0);
        final MultiSubscriber<? super O> downstream;
        final Function<? super I, ? extends Publisher<? extends O>> mapper;
        private final boolean delayError;
        final AtomicReference<Throwable> failures = new AtomicReference();
        volatile Subscription upstream = null;
        private static final AtomicReferenceFieldUpdater<ConcatMapMainSubscriber, Subscription> UPSTREAM_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ConcatMapMainSubscriber.class, Subscription.class, "upstream");
        final ConcatMapInner<O> inner;
        private final AtomicBoolean deferredUpstreamRequest = new AtomicBoolean(false);

        ConcatMapMainSubscriber(MultiSubscriber<? super O> downstream, Function<? super I, ? extends Publisher<? extends O>> mapper, boolean delayError) {
            this.downstream = downstream;
            this.mapper = mapper;
            this.delayError = delayError;
            this.inner = new ConcatMapInner(this);
        }

        public void request(long n) {
            if (n > 0L) {
                if (this.state.compareAndSet(0, 1)) {
                    this.upstream.request(1L);
                }
                if (this.deferredUpstreamRequest.compareAndSet(true, false)) {
                    this.upstream.request(1L);
                }
                this.inner.request(n);
                if (this.inner.requested() != 0L && this.deferredUpstreamRequest.compareAndSet(true, false)) {
                    this.upstream.request(1L);
                }
            } else {
                this.downstream.onFailure(Subscriptions.getInvalidRequestException());
            }
        }

        public void cancel() {
            int state;
            do {
                if ((state = this.state.get()) != 5) continue;
                return;
            } while (!this.state.compareAndSet(state, 5));
            if (state == 3) {
                this.inner.cancel();
            } else {
                this.inner.cancel();
                this.upstream.cancel();
            }
        }

        public void onSubscribe(Subscription s) {
            if (UPSTREAM_UPDATER.compareAndSet(this, null, s)) {
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onItem(I item) {
            block4: {
                if (!this.state.compareAndSet(1, 2)) {
                    return;
                }
                try {
                    Publisher<? extends O> p = this.mapper.apply(item);
                    if (p == null) {
                        throw new NullPointerException("The mapper returned `null`");
                    }
                    p.subscribe(this.inner);
                }
                catch (Throwable e) {
                    if (!this.postponeFailure(e, this.upstream)) break block4;
                    this.innerComplete(0L);
                }
            }
        }

        @Override
        public void onFailure(Throwable t) {
            if (this.postponeFailure(t, this.inner)) {
                this.onCompletion();
            }
        }

        @Override
        public void onCompletion() {
            block2: {
                while (true) {
                    int state;
                    if ((state = this.state.get()) == 0 || state == 1) {
                        if (!this.state.compareAndSet(state, 4)) continue;
                        this.terminateDownstream();
                        return;
                    }
                    if (state != 2) break block2;
                    if (this.state.compareAndSet(state, 3)) break;
                }
                return;
            }
        }

        public synchronized void tryEmit(O value) {
            switch (this.state.get()) {
                case 2: 
                case 3: {
                    this.downstream.onItem(value);
                    break;
                }
            }
        }

        public void innerComplete(long emitted) {
            if (this.state.compareAndSet(2, 1)) {
                if (this.inner.requested() != 0L || emitted == 0L) {
                    this.upstream.request(1L);
                } else {
                    this.deferredUpstreamRequest.set(true);
                }
            } else if (this.state.compareAndSet(3, 4)) {
                this.terminateDownstream();
            }
        }

        public void innerFailure(Throwable e, long emitted) {
            if (this.postponeFailure(e, this.upstream)) {
                this.innerComplete(emitted);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean postponeFailure(Throwable e, Subscription subscription) {
            int state;
            if (e == null) {
                return true;
            }
            Subscriptions.addFailure(this.failures, e);
            if (this.delayError) {
                return true;
            }
            do {
                if ((state = this.state.get()) != 5 && state != 4) continue;
                return false;
            } while (!this.state.compareAndSet(state, 4));
            subscription.cancel();
            ConcatMapMainSubscriber concatMapMainSubscriber = this;
            synchronized (concatMapMainSubscriber) {
                this.downstream.onFailure(this.failures.get());
            }
            return false;
        }

        private void terminateDownstream() {
            Throwable ex = this.failures.get();
            if (ex != null) {
                this.downstream.onFailure(ex);
                return;
            }
            this.downstream.onCompletion();
        }

        @Override
        public Context context() {
            if (this.downstream instanceof ContextSupport) {
                return ((ContextSupport)((Object)this.downstream)).context();
            }
            return Context.empty();
        }
    }

    static final class ConcatMapInner<O>
    extends SwitchableSubscriptionSubscriber<O> {
        private final ConcatMapMainSubscriber<?, O> parent;
        long emitted;

        ConcatMapInner(ConcatMapMainSubscriber<?, O> parent) {
            super(null);
            this.parent = parent;
        }

        @Override
        public void onItem(O item) {
            ++this.emitted;
            this.parent.tryEmit(item);
        }

        @Override
        public void onFailure(Throwable failure) {
            long p = this.emitted;
            if (p != 0L) {
                this.emitted = 0L;
                this.emitted(p);
            }
            this.parent.innerFailure(failure, p);
        }

        @Override
        public void onCompletion() {
            long p = this.emitted;
            if (p != 0L) {
                this.emitted = 0L;
                this.emitted(p);
            }
            this.parent.innerComplete(p);
        }

        @Override
        public Context context() {
            return this.parent.context();
        }
    }
}

