/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.ArrayDeque;
import org.reactivestreams.Subscription;

public final class MultiSkipLastOp<T>
extends AbstractMultiOperator<T, T> {
    private final int numberOfItems;

    public MultiSkipLastOp(Multi<? extends T> upstream, int numberOfItems) {
        super(upstream);
        this.numberOfItems = ParameterValidation.positiveOrZero(numberOfItems, "numberOfItems");
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> actual) {
        if (this.numberOfItems == 0) {
            this.upstream.subscribe().withSubscriber(actual);
        } else {
            this.upstream.subscribe().withSubscriber(new SkipLastProcessor<T>(actual, this.numberOfItems));
        }
    }

    static final class SkipLastProcessor<T>
    extends MultiOperatorProcessor<T, T> {
        private final int numberOfItems;
        private final ArrayDeque<T> queue = new ArrayDeque();

        SkipLastProcessor(MultiSubscriber<? super T> actual, int numberOfItems) {
            super(actual);
            this.numberOfItems = numberOfItems;
        }

        @Override
        public void onSubscribe(Subscription subscription) {
            if (this.compareAndSetUpstreamSubscription(null, subscription)) {
                this.downstream.onSubscribe(this);
                subscription.request((long)this.numberOfItems);
            } else {
                subscription.cancel();
            }
        }

        @Override
        public void onItem(T t) {
            if (this.queue.size() == this.numberOfItems) {
                this.downstream.onItem(this.queue.pollFirst());
            }
            this.queue.offerLast(t);
        }

        @Override
        public void onFailure(Throwable t) {
            this.queue.clear();
            super.onFailure(t);
        }

        @Override
        public void onCompletion() {
            this.queue.clear();
            super.onCompletion();
        }

        @Override
        public void cancel() {
            super.cancel();
            this.queue.clear();
        }
    }
}

