/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers;

import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.reactivestreams.Subscription;

public class UniCallbackSubscriber<T>
implements UniSubscriber<T>,
UniSubscription {
    private final AtomicReference<UniSubscription> subscription = new AtomicReference();
    private final Consumer<? super T> onResultCallback;
    private final Consumer<? super Throwable> onFailureCallback;

    public UniCallbackSubscriber(Consumer<? super T> onResultCallback, Consumer<? super Throwable> onFailureCallback) {
        this.onResultCallback = ParameterValidation.nonNull(onResultCallback, "onResultCallback");
        this.onFailureCallback = ParameterValidation.nonNull(onFailureCallback, "onFailureCallback");
    }

    @Override
    public final void onSubscribe(UniSubscription sub) {
        if (!this.subscription.compareAndSet(null, sub)) {
            sub.cancel();
        }
    }

    @Override
    public final void onFailure(Throwable t) {
        UniSubscription sub = this.subscription.getAndSet(EmptyUniSubscription.CANCELLED);
        if (sub == EmptyUniSubscription.CANCELLED) {
            return;
        }
        this.onFailureCallback.accept(t);
    }

    @Override
    public final void onItem(T x) {
        Subscription sub = this.subscription.getAndSet(EmptyUniSubscription.CANCELLED);
        if (sub == EmptyUniSubscription.CANCELLED) {
            return;
        }
        try {
            this.onResultCallback.accept(x);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void cancel() {
        Subscription sub = this.subscription.getAndSet(EmptyUniSubscription.CANCELLED);
        if (sub != null) {
            sub.cancel();
        }
    }
}

