/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi.builders;

import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.AbstractMulti;
import io.smallrye.mutiny.subscription.BackPressureFailure;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.time.Duration;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscription;

public class IntervalMulti
extends AbstractMulti<Long> {
    private final ScheduledExecutorService executor;
    private final Duration initialDelay;
    private final Duration period;

    public IntervalMulti(Duration initialDelay, Duration period, ScheduledExecutorService executor) {
        this.initialDelay = ParameterValidation.validate(initialDelay, "initialDelay");
        this.period = ParameterValidation.validate(period, "period");
        this.executor = ParameterValidation.nonNull(executor, "executor");
    }

    public IntervalMulti(Duration period, ScheduledExecutorService executor) {
        this.initialDelay = null;
        this.period = ParameterValidation.validate(period, "period");
        this.executor = ParameterValidation.nonNull(executor, "executor");
    }

    @Override
    public void subscribe(MultiSubscriber<? super Long> actual) {
        block4: {
            IntervalRunnable runnable = new IntervalRunnable(actual);
            actual.onSubscribe(runnable);
            try {
                if (this.initialDelay != null) {
                    this.executor.scheduleAtFixedRate(runnable, this.initialDelay.toMillis(), this.period.toMillis(), TimeUnit.MILLISECONDS);
                } else {
                    this.executor.scheduleAtFixedRate(runnable, 0L, this.period.toMillis(), TimeUnit.MILLISECONDS);
                }
            }
            catch (RejectedExecutionException ree) {
                if (runnable.cancelled.get()) break block4;
                actual.onFailure(new RejectedExecutionException(ree));
            }
        }
    }

    static final class IntervalRunnable
    implements Runnable,
    Subscription {
        private final MultiSubscriber<? super Long> actual;
        private final AtomicLong requested = new AtomicLong();
        private final AtomicBoolean cancelled = new AtomicBoolean();
        private final AtomicLong count = new AtomicLong();

        IntervalRunnable(MultiSubscriber<? super Long> actual) {
            this.actual = actual;
        }

        @Override
        public void run() {
            if (!this.cancelled.get()) {
                if (this.requested.get() != 0L) {
                    this.actual.onItem((Long)this.count.getAndIncrement());
                    if (this.requested.get() != Long.MAX_VALUE) {
                        this.requested.decrementAndGet();
                    }
                } else {
                    this.cancel();
                    this.actual.onFailure(new BackPressureFailure("Could not emit tick " + this.count + " due to lack of requests"));
                }
            }
        }

        public void request(long n) {
            if (n > 0L) {
                Subscriptions.add(this.requested, n);
            }
        }

        public void cancel() {
            this.cancelled.set(true);
        }
    }
}

