/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.UniOnItemOrFailureConsume;
import io.smallrye.mutiny.operators.UniOnItemOrFailureFlatMap;
import io.smallrye.mutiny.operators.UniOnItemOrFailureMap;
import io.smallrye.mutiny.subscription.UniEmitter;
import io.smallrye.mutiny.tuples.Functions;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public class UniOnItemOrFailure<T> {
    private final Uni<T> upstream;

    public UniOnItemOrFailure(Uni<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public Uni<T> invoke(BiConsumer<? super T, Throwable> callback) {
        return Infrastructure.onUniCreation(new UniOnItemOrFailureConsume<T>(this.upstream, ParameterValidation.nonNull(callback, "callback")));
    }

    public <R> Uni<R> apply(BiFunction<? super T, Throwable, ? extends R> mapper) {
        return Infrastructure.onUniCreation(new UniOnItemOrFailureMap<T, R>(this.upstream, mapper));
    }

    public <R> Uni<R> produceUni(BiFunction<? super T, Throwable, ? extends Uni<? extends R>> mapper) {
        return Infrastructure.onUniCreation(new UniOnItemOrFailureFlatMap(this.upstream, mapper));
    }

    public <R> Uni<R> produceUni(Functions.TriConsumer<? super T, Throwable, UniEmitter<? super R>> consumer) {
        ParameterValidation.nonNull(consumer, "consumer");
        return this.produceUni((? super T item, Throwable failure) -> Uni.createFrom().emitter(emitter -> {
            try {
                consumer.accept((Object)item, (Throwable)failure, (UniEmitter)emitter);
            }
            catch (Throwable e) {
                if (failure != null) {
                    emitter.fail(new CompositeException((Throwable)failure, e));
                }
                emitter.fail(e);
            }
        }));
    }
}

