/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.operators.UniSerializedSubscriber;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class UniCache<I>
extends UniOperator<I, I>
implements UniSubscriber<I> {
    private static final int NOT_INITIALIZED = 0;
    private static final int SUBSCRIBING = 1;
    private static final int SUBSCRIBED = 2;
    private static final int COMPLETED = 3;
    private final AtomicReference<UniSubscription> subscription = new AtomicReference();
    private final List<UniSubscriber<? super I>> subscribers = new ArrayList<UniSubscriber<? super I>>();
    private int state = 0;
    private I item;
    private Throwable failure;

    UniCache(Uni<? extends I> upstream) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void subscribing(UniSerializedSubscriber<? super I> subscriber) {
        Runnable action = null;
        UniCache uniCache = this;
        synchronized (uniCache) {
            switch (this.state) {
                case 0: {
                    this.state = 1;
                    action = () -> this.upstream().subscribe().withSubscriber(this);
                    this.subscribers.add(subscriber);
                    break;
                }
                case 1: {
                    this.subscribers.add(subscriber);
                    break;
                }
                case 2: {
                    this.subscribers.add(subscriber);
                    action = () -> subscriber.onSubscribe(() -> this.onCancellation(subscriber));
                    break;
                }
                case 3: {
                    this.subscribers.add(subscriber);
                    action = () -> {
                        subscriber.onSubscribe(() -> this.onCancellation(subscriber));
                        this.replay(subscriber);
                    };
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown state: " + this.state);
                }
            }
        }
        if (action != null) {
            action.run();
        }
    }

    private synchronized void onCancellation(UniSubscriber<? super I> subscriber) {
        this.subscribers.remove(subscriber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replay(UniSubscriber<? super I> subscriber) {
        UniCache uniCache = this;
        synchronized (uniCache) {
            if (this.state != 3) {
                throw new IllegalStateException("Invalid state - expected being in the DONE state, but is in state: " + this.state);
            }
        }
        if (this.failure != null) {
            subscriber.onFailure(this.failure);
        } else {
            subscriber.onItem(this.item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSubscribe(UniSubscription subscription) {
        ArrayList<UniSubscriber<I>> list;
        UniCache uniCache = this;
        synchronized (uniCache) {
            if (!this.subscription.compareAndSet(null, subscription)) {
                throw new IllegalStateException("Invalid state - received a second subscription from source");
            }
            this.state = 2;
            list = new ArrayList<UniSubscriber<I>>(this.subscribers);
        }
        list.forEach(s -> s.onSubscribe(() -> this.onCancellation((UniSubscriber<? super I>)s)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onItem(I item) {
        ArrayList<UniSubscriber<I>> list;
        UniCache uniCache = this;
        synchronized (uniCache) {
            if (this.state != 2) {
                throw new IllegalStateException("Invalid state - received item while we where not in the SUBSCRIBED state, current state is: " + this.state);
            }
            this.state = 3;
            this.item = item;
            list = new ArrayList<UniSubscriber<I>>(this.subscribers);
            this.subscribers.clear();
        }
        list.forEach(s -> s.onItem(item));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(Throwable failure) {
        ArrayList<UniSubscriber<I>> list;
        UniCache uniCache = this;
        synchronized (uniCache) {
            if (this.state != 2) {
                throw new IllegalStateException("Invalid state - received item while we where not in the SUBSCRIBED state, current state is: " + this.state);
            }
            this.state = 3;
            this.failure = failure;
            list = new ArrayList<UniSubscriber<I>>(this.subscribers);
            this.subscribers.clear();
        }
        list.forEach(s -> s.onFailure(failure));
    }
}

