/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi.processors;

import io.smallrye.mutiny.helpers.Subscriptions;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class DirectProcessor<T>
implements Processor<T, T> {
    private static final DirectInner[] EMPTY = new DirectInner[0];
    private static final DirectInner[] TERMINATED = new DirectInner[0];
    private AtomicReference<DirectInner<T>[]> subscribers = new AtomicReference<DirectInner[]>(EMPTY);
    Throwable failure;

    public static <E> DirectProcessor<E> create() {
        return new DirectProcessor();
    }

    public void onSubscribe(Subscription s) {
        Objects.requireNonNull(s, "s");
        if (this.subscribers.get() != TERMINATED) {
            s.request(Long.MAX_VALUE);
        } else {
            s.cancel();
        }
    }

    public void onNext(T t) {
        Objects.requireNonNull(t, "t");
        DirectInner<T>[] inners = this.subscribers.get();
        if (inners == TERMINATED) {
            return;
        }
        for (DirectInner<T> s : inners) {
            s.onNext(t);
        }
    }

    public void onError(Throwable failure) {
        Objects.requireNonNull(failure, "failure");
        DirectInner<T>[] inners = this.subscribers.get();
        if (inners == TERMINATED) {
            return;
        }
        this.failure = failure;
        for (DirectInner s : this.subscribers.getAndSet(TERMINATED)) {
            s.onError(failure);
        }
    }

    public void onComplete() {
        for (DirectInner s : this.subscribers.getAndSet(TERMINATED)) {
            s.onComplete();
        }
    }

    public void subscribe(Subscriber<? super T> actual) {
        Objects.requireNonNull(actual, "actual");
        DirectInner<? super T> p = new DirectInner<T>(actual, this);
        actual.onSubscribe(p);
        if (this.add(p)) {
            if (p.cancelled) {
                this.remove(p);
            }
        } else {
            Throwable e = this.failure;
            if (e != null) {
                actual.onError(e);
            } else {
                actual.onComplete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean add(DirectInner<T> s) {
        DirectInner<T>[] a = this.subscribers.get();
        if (a == TERMINATED) {
            return false;
        }
        DirectProcessor directProcessor = this;
        synchronized (directProcessor) {
            a = this.subscribers.get();
            if (a == TERMINATED) {
                return false;
            }
            int len = a.length;
            DirectInner[] b = new DirectInner[len + 1];
            System.arraycopy(a, 0, b, 0, len);
            b[len] = s;
            this.subscribers.set(b);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(DirectInner<T> s) {
        DirectInner<T>[] a = this.subscribers.get();
        if (a == TERMINATED || a == EMPTY) {
            return;
        }
        DirectProcessor directProcessor = this;
        synchronized (directProcessor) {
            a = this.subscribers.get();
            if (a == TERMINATED || a == EMPTY) {
                return;
            }
            int len = a.length;
            int j = -1;
            for (int i = 0; i < len; ++i) {
                if (a[i] != s) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (len == 1) {
                this.subscribers.set(EMPTY);
                return;
            }
            DirectInner[] b = new DirectInner[len - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, len - j - 1);
            this.subscribers.set(b);
        }
    }

    public Throwable getFailure() {
        if (this.subscribers.get() == TERMINATED) {
            return this.failure;
        }
        return null;
    }

    static final class DirectInner<T>
    implements Subscription {
        final Subscriber<? super T> downstream;
        final DirectProcessor<T> parent;
        volatile boolean cancelled;
        private final AtomicLong requested = new AtomicLong();

        DirectInner(Subscriber<? super T> downstream, DirectProcessor<T> parent) {
            this.downstream = downstream;
            this.parent = parent;
        }

        public void request(long n) {
            if (n > 0L) {
                Subscriptions.add(this.requested, n);
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.parent.remove(this);
            }
        }

        public void onNext(T value) {
            if (this.requested.get() != 0L) {
                this.downstream.onNext(value);
                if (this.requested.get() != Long.MAX_VALUE) {
                    this.requested.decrementAndGet();
                }
                return;
            }
            this.parent.remove(this);
            this.downstream.onError((Throwable)new IllegalStateException("Can't deliver item due to lack of requests"));
        }

        public void onError(Throwable e) {
            this.downstream.onError(e);
        }

        public void onComplete() {
            this.downstream.onComplete();
        }
    }
}

