/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ExponentialBackoff;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.MultiRetryOp;
import io.smallrye.mutiny.operators.multi.MultiRetryWhenOp;
import java.time.Duration;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;

public class MultiRetry<T> {
    private final Multi<T> upstream;
    private Duration initialBackOff;
    private Duration maxBackoff;
    private double jitter = 0.5;

    public MultiRetry(Multi<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public Multi<T> indefinitely() {
        return this.atMost(Long.MAX_VALUE);
    }

    public Multi<T> atMost(long numberOfAttempts) {
        ParameterValidation.positive(numberOfAttempts, "numberOfAttempts");
        this.validateRetryConfiguration();
        if (this.initialBackOff != null) {
            Function<Multi<Throwable>, Publisher<Long>> whenStreamFactory = ExponentialBackoff.randomExponentialBackoffFunction(numberOfAttempts, this.initialBackOff, this.maxBackoff, this.jitter, Infrastructure.getDefaultWorkerPool());
            return Infrastructure.onMultiCreation(new MultiRetryWhenOp<T>(this.upstream, whenStreamFactory));
        }
        return Infrastructure.onMultiCreation(new MultiRetryOp<T>(this.upstream, numberOfAttempts));
    }

    private void validateRetryConfiguration() {
        if (this.initialBackOff == null && this.jitter != 0.5) {
            throw new IllegalArgumentException("Invalid retry configuration, `jitter` must be used in combination with back-off");
        }
    }

    public Multi<T> until(Predicate<? super Throwable> predicate) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Multi<T> when(Function<Multi<Throwable>, ? extends Publisher<?>> whenStreamFactory) {
        if (this.initialBackOff != null || this.maxBackoff != null || this.jitter != 0.5) {
            throw new IllegalArgumentException("Invalid retry configuration, `when` cannot be used with a back-off configuration");
        }
        return Infrastructure.onMultiCreation(new MultiRetryWhenOp<T>(this.upstream, whenStreamFactory));
    }

    public MultiRetry<T> withBackOff(Duration initialBackOff) {
        return this.withBackOff(initialBackOff, ExponentialBackoff.MAX_BACKOFF);
    }

    public MultiRetry<T> withBackOff(Duration initialBackOff, Duration maxBackOff) {
        this.initialBackOff = ParameterValidation.validate(initialBackOff, "initialBackOff");
        this.maxBackoff = ParameterValidation.validate(maxBackOff, "maxBackOff");
        return this;
    }

    public MultiRetry<T> withJitter(double jitter) {
        if (jitter < 0.0 || jitter > 1.0) {
            throw new IllegalArgumentException("Invalid `jitter`, the value must be in [0.0, 1.0]");
        }
        this.jitter = jitter;
        return this;
    }
}

