/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.groups.MultiOnCompletion;
import io.smallrye.mutiny.groups.MultiOnFailure;
import io.smallrye.mutiny.groups.MultiOnItem;
import io.smallrye.mutiny.groups.MultiOverflow;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.MultiSignalConsumerOp;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import java.util.function.Predicate;
import org.reactivestreams.Subscription;

public class MultiOnEvent<T> {
    private final Multi<T> upstream;

    public MultiOnEvent(Multi<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public Multi<T> subscribed(Consumer<? super Subscription> callback) {
        return Infrastructure.onMultiCreation(new MultiSignalConsumerOp<T>(this.upstream, ParameterValidation.nonNull(callback, "callback"), null, null, null, null, null, null));
    }

    public Multi<T> cancellation(Runnable callback) {
        return Infrastructure.onMultiCreation(new MultiSignalConsumerOp<T>(this.upstream, null, null, null, null, null, null, ParameterValidation.nonNull(callback, "callback")));
    }

    public Multi<T> request(LongConsumer callback) {
        return Infrastructure.onMultiCreation(new MultiSignalConsumerOp<T>(this.upstream, null, null, null, null, null, ParameterValidation.nonNull(callback, "callback"), null));
    }

    public MultiOverflow<T> overflow() {
        return new MultiOverflow<T>(this.upstream);
    }

    public Multi<T> termination(BiConsumer<Throwable, Boolean> callback) {
        return Infrastructure.onMultiCreation(new MultiSignalConsumerOp<T>(this.upstream, null, null, null, null, callback, null, null));
    }

    public MultiOnItem<T> item() {
        return this.upstream.onItem();
    }

    public MultiOnFailure<T> failure() {
        return this.upstream.onFailure();
    }

    public MultiOnCompletion<T> completion() {
        return this.upstream.onCompletion();
    }

    public MultiOnFailure<T> failure(Predicate<? super Throwable> predicate) {
        return this.upstream.onFailure(predicate);
    }

    public MultiOnFailure<T> failure(Class<? extends Throwable> typeOfFailure) {
        return this.upstream.onFailure(typeOfFailure);
    }

    public Multi<T> completion(Runnable callback) {
        return Infrastructure.onMultiCreation(new MultiSignalConsumerOp<T>(this.upstream, null, null, null, ParameterValidation.nonNull(callback, "callback"), null, null, null));
    }
}

