/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.UniDelegatingSubscriber;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.operators.UniSerializedSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.function.Consumer;

public class UniOnSubscription<T>
extends UniOperator<T, T> {
    private final Consumer<? super UniSubscription> consumer;

    public UniOnSubscription(Uni<T> upstream, Consumer<? super UniSubscription> consumer) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
        this.consumer = ParameterValidation.nonNull(consumer, "consumer");
    }

    @Override
    protected void subscribing(final UniSerializedSubscriber<? super T> subscriber) {
        this.upstream().subscribe().withSubscriber(new UniDelegatingSubscriber<T, T>(subscriber){

            @Override
            public void onSubscribe(UniSubscription subscription) {
                try {
                    UniOnSubscription.this.consumer.accept(subscription);
                }
                catch (Exception e) {
                    subscriber.onSubscribe(EmptyUniSubscription.CANCELLED);
                    subscriber.onFailure(e);
                    return;
                }
                subscriber.onSubscribe(subscription);
            }
        });
    }
}

