/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import io.smallrye.mutiny.subscription.SwitchableSubscriptionSubscriber;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class MultiOnFailureResumeOp<T>
extends AbstractMultiOperator<T, T> {
    private final Function<? super Throwable, ? extends Publisher<? extends T>> next;

    public MultiOnFailureResumeOp(Multi<? extends T> upstream, Function<? super Throwable, ? extends Publisher<? extends T>> next) {
        super(upstream);
        this.next = ParameterValidation.nonNull(next, "next");
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> downstream) {
        this.upstream.subscribe(new ResumeSubscriber<T>(downstream, this.next));
    }

    static final class ResumeSubscriber<T>
    extends SwitchableSubscriptionSubscriber<T> {
        private final Function<? super Throwable, ? extends Publisher<? extends T>> next;
        private boolean switched;

        ResumeSubscriber(MultiSubscriber<? super T> downstream, Function<? super Throwable, ? extends Publisher<? extends T>> next) {
            super(downstream);
            this.next = next;
        }

        @Override
        public void onSubscribe(Subscription su) {
            if (!this.switched) {
                this.downstream.onSubscribe(this);
            }
            super.setOrSwitchUpstream(su);
        }

        @Override
        public void onItem(T item) {
            this.downstream.onItem(item);
            if (!this.switched) {
                this.emitted(1L);
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            if (!this.switched) {
                Publisher<? extends T> publisher;
                this.switched = true;
                try {
                    publisher = this.next.apply(failure);
                    if (publisher == null) {
                        throw new NullPointerException("The supplier returned `null`");
                    }
                }
                catch (Throwable e) {
                    if (e == failure) {
                        super.onFailure(e);
                    } else {
                        super.onFailure(new CompositeException(failure, e));
                    }
                    return;
                }
                publisher.subscribe((Subscriber)this);
            } else {
                super.onFailure(failure);
            }
        }
    }
}

