/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.function.Function;

public final class MultiMapOp<T, U>
extends AbstractMultiOperator<T, U> {
    private final Function<? super T, ? extends U> mapper;

    public MultiMapOp(Multi<T> upstream, Function<? super T, ? extends U> mapper) {
        super(upstream);
        this.mapper = ParameterValidation.nonNull(mapper, "mapper");
    }

    @Override
    public void subscribe(MultiSubscriber<? super U> downstream) {
        if (downstream == null) {
            throw new NullPointerException("Subscriber is `null`");
        }
        this.upstream.subscribe(new MapProcessor<T, U>(downstream, this.mapper));
    }

    static class MapProcessor<I, O>
    extends MultiOperatorProcessor<I, O> {
        private final Function<? super I, ? extends O> mapper;

        MapProcessor(MultiSubscriber<? super O> actual, Function<? super I, ? extends O> mapper) {
            super(actual);
            this.mapper = mapper;
        }

        @Override
        public void onItem(I item) {
            O v;
            if (this.isDone()) {
                return;
            }
            try {
                v = this.mapper.apply(item);
            }
            catch (Throwable ex) {
                this.failAndCancel(ex);
                return;
            }
            if (v == null) {
                this.failAndCancel(new NullPointerException("The mapper returned `null`"));
            } else {
                this.downstream.onItem(v);
            }
        }
    }
}

