/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.UniOnFailure;
import io.smallrye.mutiny.groups.UniOnItem;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.UniOnCancellation;
import io.smallrye.mutiny.operators.UniOnSubscription;
import io.smallrye.mutiny.operators.UniOnTermination;
import io.smallrye.mutiny.subscription.UniSubscription;
import io.smallrye.mutiny.tuples.Functions;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class UniOnEvent<T> {
    private final Uni<T> upstream;

    public UniOnEvent(Uni<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public Uni<T> subscription(Consumer<? super UniSubscription> consumer) {
        return Infrastructure.onUniCreation(new UniOnSubscription<T>(this.upstream, ParameterValidation.nonNull(consumer, "consumer")));
    }

    public Uni<T> cancellation(Runnable runnable) {
        return Infrastructure.onUniCreation(new UniOnCancellation<T>(this.upstream, ParameterValidation.nonNull(runnable, "runnable")));
    }

    public Uni<T> termination(Functions.TriConsumer<T, Throwable, Boolean> consumer) {
        return Infrastructure.onUniCreation(new UniOnTermination<T>(this.upstream, ParameterValidation.nonNull(consumer, "consumer")));
    }

    public UniOnItem<T> item() {
        return this.upstream.onItem();
    }

    public UniOnFailure<T> onFailure() {
        return this.upstream.onFailure();
    }

    public UniOnFailure<T> onFailure(Predicate<? super Throwable> predicate) {
        return this.upstream.onFailure(predicate);
    }

    public UniOnFailure<T> onFailure(Class<? extends Throwable> typeOfFailure) {
        return this.upstream.onFailure(typeOfFailure);
    }
}

