/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.MultiCollector;
import java.time.Duration;

public class MultiGroupIntoMultis<T> {
    private final Multi<T> upstream;

    public MultiGroupIntoMultis(Multi<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public Multi<Multi<T>> every(Duration duration) {
        return MultiCollector.multi(this.upstream, ParameterValidation.validate(duration, "duration"));
    }

    public Multi<Multi<T>> of(int size) {
        return MultiCollector.multi(this.upstream, ParameterValidation.positive(size, "size"));
    }

    public Multi<Multi<T>> of(int size, int skip) {
        return MultiCollector.multi(this.upstream, ParameterValidation.positive(size, "size"), ParameterValidation.positive(skip, "skip"));
    }
}

