/*
 * Decompiled with CFR 0.152.
 */
package mutiny.zero.internal;

import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.function.Function;

public class MapOperator<I, O>
implements Flow.Publisher<O> {
    private final Flow.Publisher<I> upstream;
    private final Function<I, O> mapper;

    public MapOperator(Flow.Publisher<I> upstream, Function<I, O> mapper) {
        this.upstream = upstream;
        this.mapper = mapper;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super O> subscriber) {
        this.upstream.subscribe(new MapProcessor(subscriber));
    }

    private class MapProcessor
    implements Flow.Processor<I, O>,
    Flow.Subscription {
        private final Flow.Subscriber<? super O> downstream;
        private Flow.Subscription subscription;
        private volatile boolean cancelled = false;

        public MapProcessor(Flow.Subscriber<? super O> downstream) {
            this.downstream = downstream;
        }

        @Override
        public void subscribe(Flow.Subscriber<? super O> subscriber) {
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            this.subscription = subscription;
            this.downstream.onSubscribe(this);
        }

        @Override
        public void onNext(I i) {
            Object res;
            if (this.cancelled) {
                return;
            }
            try {
                res = Objects.requireNonNull(MapOperator.this.mapper.apply(i));
            }
            catch (Exception e) {
                this.subscription.cancel();
                this.onError(e);
                return;
            }
            this.downstream.onNext(res);
        }

        @Override
        public void onError(Throwable throwable) {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            this.downstream.onError(throwable);
        }

        @Override
        public void onComplete() {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            this.downstream.onComplete();
        }

        @Override
        public void request(long n) {
            if (this.cancelled) {
                return;
            }
            this.subscription.request(n);
        }

        @Override
        public void cancel() {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            this.subscription.cancel();
        }
    }
}

