/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.shaded.org.jctools.queues.atomic.unpadded;

import io.smallrye.mutiny.shaded.org.jctools.queues.atomic.AtomicQueueUtil;
import io.smallrye.mutiny.shaded.org.jctools.queues.atomic.unpadded.MpscChunkedAtomicUnpaddedArrayQueueColdProducerFields;
import io.smallrye.mutiny.shaded.org.jctools.util.Pow2;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class MpscChunkedAtomicUnpaddedArrayQueue<E>
extends MpscChunkedAtomicUnpaddedArrayQueueColdProducerFields<E> {
    public MpscChunkedAtomicUnpaddedArrayQueue(int maxCapacity) {
        super(Math.max(2, Math.min(1024, Pow2.roundToPowerOfTwo(maxCapacity / 8))), maxCapacity);
    }

    public MpscChunkedAtomicUnpaddedArrayQueue(int initialCapacity, int maxCapacity) {
        super(initialCapacity, maxCapacity);
    }

    @Override
    protected long availableInQueue(long pIndex, long cIndex) {
        return this.maxQueueCapacity - (pIndex - cIndex);
    }

    @Override
    public int capacity() {
        return (int)(this.maxQueueCapacity / 2L);
    }

    @Override
    protected int getNextBufferSize(AtomicReferenceArray<E> buffer) {
        return AtomicQueueUtil.length(buffer);
    }

    @Override
    protected long getCurrentBufferCapacity(long mask) {
        return mask;
    }
}

