/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.MultiRepeatUntilOp;
import io.smallrye.mutiny.operators.multi.MultiRepeatWhilstOp;
import io.smallrye.mutiny.shaded.io.smallrye.common.annotation.CheckReturnValue;
import java.time.Duration;
import java.util.function.Predicate;

public class UniRepeat<T> {
    private final Uni<T> upstream;
    private final Uni<?> delay;

    public UniRepeat(Uni<T> upstream) {
        this(upstream, null);
    }

    public UniRepeat(Uni<T> upstream, Uni<?> delay) {
        this.upstream = upstream;
        this.delay = delay;
    }

    @CheckReturnValue
    public UniRepeat<T> withDelay(Duration delay) {
        ParameterValidation.validate(delay, "delay");
        return new UniRepeat<T>(this.upstream, Uni.createFrom().voidItem().onItem().delayIt().by(delay));
    }

    @CheckReturnValue
    public Multi<T> indefinitely() {
        return this.atMost(Long.MAX_VALUE);
    }

    @CheckReturnValue
    public Multi<T> atMost(long times) {
        long actual = ParameterValidation.positive(times, "times");
        return new MultiRepeatUntilOp<T>(this.upstream.toMulti(), actual, this.delay);
    }

    @CheckReturnValue
    public Multi<T> until(Predicate<T> predicate) {
        Predicate<T> actual = Infrastructure.decorate(ParameterValidation.nonNull(predicate, "predicate"));
        return new MultiRepeatUntilOp<T>(this.upstream.toMulti(), actual, this.delay);
    }

    @CheckReturnValue
    public Multi<T> whilst(Predicate<T> predicate) {
        Predicate<T> actual = Infrastructure.decorate(ParameterValidation.nonNull(predicate, "predicate"));
        return new MultiRepeatWhilstOp<T>(this.upstream.toMulti(), actual, this.delay);
    }
}

