/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.TimeoutException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.uni.UniFailOnTimeout;
import io.smallrye.mutiny.shaded.io.smallrye.common.annotation.CheckReturnValue;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;

public class UniOnTimeout<T> {
    private final Uni<T> failure;
    private final Duration timeout;
    private final ScheduledExecutorService executor;

    public UniOnTimeout(Uni<T> upstream, Duration timeout, ScheduledExecutorService executor) {
        this.failure = ParameterValidation.nonNull(upstream, "upstream");
        this.timeout = timeout;
        this.executor = executor;
    }

    @CheckReturnValue
    public UniOnTimeout<T> after(Duration timeout) {
        return new UniOnTimeout<T>(this.failure, ParameterValidation.validate(timeout, "timeout"), this.executor);
    }

    @CheckReturnValue
    public UniOnTimeout<T> on(ScheduledExecutorService executor) {
        return new UniOnTimeout<T>(this.failure, this.timeout, ParameterValidation.nonNull(executor, "executor"));
    }

    @CheckReturnValue
    public Uni<T> fail() {
        return Infrastructure.onUniCreation(this.failWith(TimeoutException::new));
    }

    @CheckReturnValue
    public Uni<T> failWith(Throwable failure) {
        return this.failWith(() -> failure);
    }

    @CheckReturnValue
    public Uni<T> failWith(Supplier<? extends Throwable> supplier) {
        ParameterValidation.validate(this.timeout, "timeout");
        Supplier<? extends Throwable> actual = Infrastructure.decorate(ParameterValidation.nonNull(supplier, "supplier"));
        return Infrastructure.onUniCreation(new UniFailOnTimeout<T>(this.failure, this.timeout, actual, this.executor));
    }

    @CheckReturnValue
    public Uni<T> recoverWithItem(T fallback) {
        return this.fail().onFailure(TimeoutException.class).recoverWithItem(fallback);
    }

    @CheckReturnValue
    public Uni<T> recoverWithItem(Supplier<T> supplier) {
        return this.fail().onFailure(TimeoutException.class).recoverWithItem(supplier);
    }

    @CheckReturnValue
    public Uni<T> recoverWithUni(Supplier<Uni<? extends T>> supplier) {
        return this.fail().onFailure(TimeoutException.class).recoverWithUni(supplier);
    }

    @CheckReturnValue
    public Uni<T> recoverWithUni(Uni<? extends T> fallback) {
        return this.fail().onFailure(TimeoutException.class).recoverWithUni(fallback);
    }
}

