/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.UniOnItem;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.shaded.io.smallrye.common.annotation.CheckReturnValue;
import java.util.function.Supplier;

public class UniOnItemIgnore<T> {
    private final UniOnItem<T> onItem;

    public UniOnItemIgnore(UniOnItem<T> onItem) {
        this.onItem = ParameterValidation.nonNull(onItem, "onItem");
    }

    @CheckReturnValue
    public Uni<T> andFail(Throwable failure) {
        ParameterValidation.nonNull(failure, "failure");
        return this.andFail(() -> failure);
    }

    @CheckReturnValue
    public Uni<T> andFail(Supplier<Throwable> supplier) {
        Supplier<Throwable> actual = Infrastructure.decorate(ParameterValidation.nonNull(supplier, "supplier"));
        return this.onItem.transformToUni(ignored -> Uni.createFrom().failure((Throwable)actual.get()));
    }

    @CheckReturnValue
    public Uni<T> andFail() {
        return this.andFail(new Exception("Ignored and Failed"));
    }

    @CheckReturnValue
    public <O> Uni<O> andSwitchTo(Uni<? extends O> other) {
        ParameterValidation.nonNull(other, "other");
        return this.onItem.transformToUni(ignored -> other);
    }

    @CheckReturnValue
    public <O> Uni<O> andSwitchTo(Supplier<Uni<? extends O>> supplier) {
        ParameterValidation.nonNull(supplier, "supplier");
        return this.onItem.transformToUni(ignored -> (Uni)supplier.get());
    }

    @CheckReturnValue
    public Uni<T> andContinueWith(T fallback) {
        return this.onItem.transform(ignored -> fallback);
    }

    @CheckReturnValue
    public Uni<Void> andContinueWithNull() {
        return this.onItem.transform(ignored -> null);
    }

    @CheckReturnValue
    public Uni<T> andContinueWith(Supplier<? extends T> supplier) {
        Supplier actual = Infrastructure.decorate(ParameterValidation.nonNull(supplier, "supplier"));
        return this.onItem.transform(ignored -> actual.get());
    }
}

