/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.uni.UniOnCancellation;
import io.smallrye.mutiny.operators.uni.UniOnCancellationCall;
import io.smallrye.mutiny.shaded.io.smallrye.common.annotation.CheckReturnValue;
import java.util.function.Supplier;

public class UniOnCancel<T> {
    private final Uni<T> upstream;

    public UniOnCancel(Uni<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    @CheckReturnValue
    public Uni<T> invoke(Runnable action) {
        Runnable actual = Infrastructure.decorate(ParameterValidation.nonNull(action, "action"));
        return Infrastructure.onUniCreation(new UniOnCancellation<T>(this.upstream, actual));
    }

    @CheckReturnValue
    public Uni<T> call(Supplier<Uni<?>> supplier) {
        Supplier<Uni<?>> actual = Infrastructure.decorate(ParameterValidation.nonNull(supplier, "supplier"));
        return Infrastructure.onUniCreation(new UniOnCancellationCall<T>(this.upstream, actual));
    }
}

