/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.uni.UniMemoizeOp;
import io.smallrye.mutiny.shaded.io.smallrye.common.annotation.CheckReturnValue;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.function.BooleanSupplier;

public class UniMemoize<T> {
    private final Uni<T> upstream;

    public UniMemoize(AbstractUni<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    @CheckReturnValue
    public Uni<T> until(BooleanSupplier invalidationGuard) {
        BooleanSupplier actual = Infrastructure.decorate(ParameterValidation.nonNull(invalidationGuard, "invalidationGuard"));
        return Infrastructure.onUniCreation(new UniMemoizeOp<T>(this.upstream, actual));
    }

    @Deprecated(forRemoval=true)
    @CheckReturnValue
    public Uni<T> atLeast(Duration duration) {
        return this.forFixedDuration(duration);
    }

    @CheckReturnValue
    public Uni<T> forFixedDuration(Duration duration) {
        final Duration validatedDuration = ParameterValidation.validate(duration, "duration");
        return this.until(new BooleanSupplier(){
            private volatile long startTime = -1L;

            @Override
            public boolean getAsBoolean() {
                boolean invalidates;
                long now = System.nanoTime();
                if (this.startTime == -1L) {
                    this.startTime = now;
                }
                if (validatedDuration == ChronoUnit.FOREVER.getDuration()) {
                    this.startTime = now;
                    return false;
                }
                boolean bl = invalidates = now - this.startTime > validatedDuration.toNanos();
                if (invalidates) {
                    this.startTime = now;
                }
                return invalidates;
            }
        });
    }

    @CheckReturnValue
    public Uni<T> indefinitely() {
        return this.until(() -> false);
    }
}

