/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.builders.IntervalMulti;
import io.smallrye.mutiny.shaded.io.smallrye.common.annotation.CheckReturnValue;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;

public class MultiTimePeriod {
    private Duration initialDelay;
    private ScheduledExecutorService executor;

    @CheckReturnValue
    public MultiTimePeriod startingAfter(Duration duration) {
        this.initialDelay = ParameterValidation.validate(duration, "duration");
        return this;
    }

    @CheckReturnValue
    public MultiTimePeriod onExecutor(ScheduledExecutorService executor) {
        this.executor = ParameterValidation.nonNull(executor, "executor");
        return this;
    }

    @CheckReturnValue
    public Multi<Long> every(Duration duration) {
        ParameterValidation.validate(duration, "duration");
        ScheduledExecutorService executorService = this.executor;
        if (executorService == null) {
            executorService = Infrastructure.getDefaultWorkerPool();
        }
        if (this.initialDelay != null) {
            return Infrastructure.onMultiCreation(new IntervalMulti(this.initialDelay, duration, executorService));
        }
        return Infrastructure.onMultiCreation(new IntervalMulti(duration, executorService));
    }
}

