/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.MultiDistinctByKeyOp;
import io.smallrye.mutiny.operators.multi.MultiDistinctOp;
import io.smallrye.mutiny.operators.multi.MultiSelectFirstOp;
import io.smallrye.mutiny.operators.multi.MultiSelectFirstUntilOtherOp;
import io.smallrye.mutiny.operators.multi.MultiSelectFirstWhileOp;
import io.smallrye.mutiny.operators.multi.MultiSelectLastOp;
import io.smallrye.mutiny.operators.multi.MultiSelectWhereOp;
import io.smallrye.mutiny.shaded.io.smallrye.common.annotation.CheckReturnValue;
import java.time.Duration;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.Predicate;

public class MultiSelect<T> {
    private final Multi<T> upstream;

    public MultiSelect(Multi<T> upstream) {
        this.upstream = upstream;
    }

    @CheckReturnValue
    public Multi<T> first() {
        return this.first(1L);
    }

    @CheckReturnValue
    public Multi<T> last() {
        return this.last(1);
    }

    @CheckReturnValue
    public Multi<T> first(long n) {
        return Infrastructure.onMultiCreation(new MultiSelectFirstOp<T>(this.upstream, n));
    }

    @CheckReturnValue
    public Multi<T> last(int n) {
        return Infrastructure.onMultiCreation(new MultiSelectLastOp<T>(this.upstream, n));
    }

    @CheckReturnValue
    public Multi<T> first(Predicate<? super T> predicate) {
        Predicate<? super T> actual = Infrastructure.decorate(ParameterValidation.nonNull(predicate, "predicate"));
        return Infrastructure.onMultiCreation(new MultiSelectFirstWhileOp<T>(this.upstream, actual));
    }

    @CheckReturnValue
    public Multi<T> first(Duration duration) {
        Multi<Long> ticks = Multi.createFrom().ticks().startingAfter(duration).every(duration);
        return Infrastructure.onMultiCreation(new MultiSelectFirstUntilOtherOp<T, Long>(this.upstream, ticks));
    }

    @CheckReturnValue
    public Multi<T> where(Predicate<? super T> predicate) {
        Predicate<? super T> actual = Infrastructure.decorate(ParameterValidation.nonNull(predicate, "predicate"));
        return Infrastructure.onMultiCreation(new MultiSelectWhereOp<T>(this.upstream, actual));
    }

    @CheckReturnValue
    public Multi<T> where(Predicate<? super T> predicate, int limit) {
        return this.where(predicate).select().first(limit);
    }

    @CheckReturnValue
    public Multi<T> when(Function<? super T, Uni<Boolean>> predicate) {
        Function actual = Infrastructure.decorate(ParameterValidation.nonNull(predicate, "predicate"));
        return this.upstream.onItem().transformToMultiAndConcatenate(res -> {
            Uni uni = (Uni)actual.apply(res);
            return uni.map(pass -> pass != false ? res : null).toMulti();
        });
    }

    @CheckReturnValue
    public Multi<T> distinct() {
        return Infrastructure.onMultiCreation(new MultiDistinctOp<T>(this.upstream));
    }

    @CheckReturnValue
    public Multi<T> distinct(Comparator<? super T> comparator) {
        return Infrastructure.onMultiCreation(new MultiDistinctOp<T>(this.upstream, comparator));
    }

    @CheckReturnValue
    public <K> Multi<T> distinct(Function<T, K> keyExtractor) {
        return Infrastructure.onMultiCreation(new MultiDistinctByKeyOp<T, K>(this.upstream, Infrastructure.decorate(ParameterValidation.nonNull(keyExtractor, "keyExtractor"))));
    }
}

